/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

import org.systemsbiology.math.MathFunctions;

public class SignificantDigitsCalculator {
    Double mRelTol;
    Double mAbsTol;
    public static final int SIGNIFICANT_DIGITS_UNKNOWN = -1;
    private static final Double DEFAULT_RELATIVE_TOLERANCE = new Double(1.0E-6);

    public SignificantDigitsCalculator() {
        this(DEFAULT_RELATIVE_TOLERANCE, null);
    }

    public SignificantDigitsCalculator(Double pRelTol, Double pAbsTol) {
        this.setRelTol(pRelTol);
        this.setAbsTol(pAbsTol);
    }

    public void setRelTol(Double pRelTol) {
        double relTolValue;
        if (pRelTol != null && ((relTolValue = pRelTol.doubleValue()) <= 0.0 || relTolValue >= 1.0)) {
            throw new IllegalArgumentException("illegal relative tolerance: " + pRelTol.toString());
        }
        this.mRelTol = pRelTol;
    }

    public void setAbsTol(Double pAbsTol) {
        if (pAbsTol != null && pAbsTol <= 0.0) {
            throw new IllegalArgumentException("illegal absolutetolerance: " + pAbsTol.toString());
        }
        this.mAbsTol = pAbsTol;
    }

    public Double getRelTol() {
        return this.mRelTol;
    }

    public Double getAbsTol() {
        return this.mAbsTol;
    }

    public int calculate(double pValue) {
        if (Double.isNaN(pValue) || Double.isInfinite(pValue) || this.mRelTol == null && this.mAbsTol == null) {
            return -1;
        }
        if (0.0 == pValue) {
            if (this.mAbsTol != null) {
                double errorFromAbsTol = this.mAbsTol;
                if (errorFromAbsTol < 1.0) {
                    return 1 + (int)Math.rint(-1.0 * MathFunctions.log10(errorFromAbsTol));
                }
                return -1;
            }
            return -1;
        }
        double absValue = Math.abs(pValue);
        MathFunctions.log10(absValue);
        double errorFromRelTol = Double.MAX_VALUE;
        if (this.mRelTol != null) {
            errorFromRelTol = absValue * this.mRelTol;
        }
        double errorFromAbsTol = Double.MAX_VALUE;
        if (this.mAbsTol != null) {
            errorFromAbsTol = this.mAbsTol;
        }
        double actualError = Math.min(errorFromRelTol, errorFromAbsTol);
        MathFunctions.log10(actualError);
        double ratio = absValue / actualError;
        int numSignificantDigits = 1 + (int)Math.rint(MathFunctions.log10(ratio));
        return numSignificantDigits;
    }

    public static final void main(String[] pArgs) {
    }
}

