/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

import org.systemsbiology.math.Value;

public final class Symbol {
    final String mSymbolName;
    int mArrayIndex;
    double[] mDoubleArray;
    Value[] mValueArray;
    public static final int NULL_ARRAY_INDEX = -1;

    public Symbol(String pSymbolName) throws IllegalArgumentException {
        this.mSymbolName = pSymbolName;
        this.clearIndexInfo();
    }

    public boolean hasArrayIndex() {
        return -1 != this.mArrayIndex;
    }

    public String getName() {
        return this.mSymbolName;
    }

    public void setArrayIndex(int pArrayIndex) {
        this.mArrayIndex = pArrayIndex;
    }

    public int getArrayIndex() {
        return this.mArrayIndex;
    }

    public void setArray(double[] pArray) {
        this.mDoubleArray = pArray;
        this.mValueArray = null;
    }

    public void setArray(Value[] pArray) {
        this.mDoubleArray = null;
        this.mValueArray = pArray;
    }

    public double[] getDoubleArray() {
        return this.mDoubleArray;
    }

    public Value[] getValueArray() {
        return this.mValueArray;
    }

    public boolean equals(Symbol pSymbol) {
        return this.mSymbolName.equals(pSymbol.mSymbolName) && this.mArrayIndex == pSymbol.mArrayIndex;
    }

    public Object clone() {
        Symbol newSymbol = new Symbol(this.mSymbolName);
        return newSymbol;
    }

    public void copyIndexInfo(Symbol pSymbol) {
        assert (pSymbol.getName().equals(this.mSymbolName)) : "inconsistent symbol names";
        this.mArrayIndex = pSymbol.mArrayIndex;
        this.mDoubleArray = pSymbol.mDoubleArray;
        this.mValueArray = pSymbol.mValueArray;
    }

    public void clearIndexInfo() {
        this.mArrayIndex = -1;
        this.mDoubleArray = null;
        this.mValueArray = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getName()) + "; index: " + this.mArrayIndex + "; array: " + this.mDoubleArray);
        return sb.toString();
    }
}

