/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

import org.systemsbiology.math.Expression;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolEvaluationPostProcessor;
import org.systemsbiology.util.DataNotFoundException;

public abstract class SymbolEvaluator
implements Cloneable {
    protected static final int NULL_ARRAY_INDEX = -1;
    private final boolean mUseExpressionValueCaching;
    private final SymbolEvaluationPostProcessor mSymbolEvaluationPostProcessor;

    public SymbolEvaluator() {
        this(false, null);
    }

    public SymbolEvaluationPostProcessor getSymbolEvaluationPostProcessor() {
        return this.mSymbolEvaluationPostProcessor;
    }

    public SymbolEvaluator(boolean pUseExpressionValueCaching, SymbolEvaluationPostProcessor pSymbolEvaluationPostProcessor) {
        this.mUseExpressionValueCaching = pUseExpressionValueCaching;
        this.mSymbolEvaluationPostProcessor = pSymbolEvaluationPostProcessor;
    }

    protected final double getIndexedValue(int pArrayIndex, Symbol pSymbol) throws DataNotFoundException {
        double[] doubleArray = pSymbol.mDoubleArray;
        if (doubleArray != null) {
            if (this.mSymbolEvaluationPostProcessor == null) {
                return doubleArray[pArrayIndex];
            }
            return this.mSymbolEvaluationPostProcessor.modifyResult(pSymbol, this, doubleArray[pArrayIndex]);
        }
        if (!this.mUseExpressionValueCaching) {
            if (this.mSymbolEvaluationPostProcessor == null) {
                return pSymbol.mValueArray[pArrayIndex].getValue(this);
            }
            return this.mSymbolEvaluationPostProcessor.modifyResult(pSymbol, this, pSymbol.mValueArray[pArrayIndex].getValue(this));
        }
        if (this.mSymbolEvaluationPostProcessor == null) {
            return pSymbol.mValueArray[pArrayIndex].getValueWithCaching(this);
        }
        return this.mSymbolEvaluationPostProcessor.modifyResult(pSymbol, this, pSymbol.mValueArray[pArrayIndex].getValueWithCaching(this));
    }

    public abstract Expression getExpressionValue(Symbol var1) throws DataNotFoundException;

    public final double getValue(Symbol pSymbol) throws DataNotFoundException {
        if (-1 == pSymbol.mArrayIndex) {
            return this.getUnindexedValue(pSymbol);
        }
        if (pSymbol.mDoubleArray != null) {
            if (this.mSymbolEvaluationPostProcessor == null) {
                return pSymbol.mDoubleArray[pSymbol.mArrayIndex];
            }
            return this.mSymbolEvaluationPostProcessor.modifyResult(pSymbol, this, pSymbol.mDoubleArray[pSymbol.mArrayIndex]);
        }
        if (!this.mUseExpressionValueCaching) {
            if (this.mSymbolEvaluationPostProcessor == null) {
                return pSymbol.mValueArray[pSymbol.mArrayIndex].getValue(this);
            }
            return this.mSymbolEvaluationPostProcessor.modifyResult(pSymbol, this, pSymbol.mValueArray[pSymbol.mArrayIndex].getValue(this));
        }
        if (this.mSymbolEvaluationPostProcessor == null) {
            return pSymbol.mValueArray[pSymbol.mArrayIndex].getValueWithCaching(this);
        }
        return this.mSymbolEvaluationPostProcessor.modifyResult(pSymbol, this, pSymbol.mValueArray[pSymbol.mArrayIndex].getValueWithCaching(this));
    }

    public abstract boolean hasValue(Symbol var1);

    public abstract double getUnindexedValue(Symbol var1) throws DataNotFoundException;
}

