/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

import java.util.HashMap;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolEvaluator;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.math.Value;
import org.systemsbiology.util.DataNotFoundException;

public class SymbolEvaluatorHashMap
extends SymbolEvaluator {
    protected final HashMap mSymbolMap;

    public SymbolEvaluatorHashMap(HashMap pSymbolMap) {
        this.mSymbolMap = pSymbolMap;
    }

    protected double getValue(String pSymbolName) throws DataNotFoundException {
        SymbolValue symbolValue = (SymbolValue)this.mSymbolMap.get(pSymbolName);
        double value = 0.0;
        if (symbolValue != null) {
            Value valueObj = symbolValue.getValue();
            if (valueObj == null) {
                throw new IllegalStateException("no value was assigned for symbol: " + symbolValue.getSymbol().getName());
            }
        } else {
            throw new DataNotFoundException("unable to evaluate symbol: " + pSymbolName);
        }
        value = symbolValue.getValue().getValue(this);
        return value;
    }

    public double getUnindexedValue(Symbol pSymbol) throws DataNotFoundException {
        return this.getValue(pSymbol.getName());
    }

    public boolean hasValue(Symbol pSymbol) {
        String symbolName = pSymbol.getName();
        SymbolValue symbolValue = (SymbolValue)this.mSymbolMap.get(symbolName);
        return symbolValue != null;
    }

    public Expression getExpressionValue(Symbol pSymbol) throws DataNotFoundException {
        String symbolName = pSymbol.getName();
        SymbolValue symbolValue = (SymbolValue)this.mSymbolMap.get(symbolName);
        if (symbolValue == null) {
            throw new DataNotFoundException("unable to find symbol in symbol map, symbol is \"" + symbolName + "\"");
        }
        Value value = symbolValue.getValue();
        Expression retVal = null;
        if (value != null && value.isExpression()) {
            retVal = value.getExpressionValue();
        }
        return retVal;
    }
}

