/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

import java.util.HashMap;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.Value;

public class SymbolValue
implements Comparable {
    protected Value mValue;
    protected final Symbol mSymbol;

    public SymbolValue(String pSymbolName) {
        this(pSymbolName, null);
    }

    public SymbolValue(String pSymbolName, double pSymbolValue) {
        this(pSymbolName, new Value(pSymbolValue));
    }

    public SymbolValue(SymbolValue pSymbolValue) {
        this.mValue = pSymbolValue.mValue;
        this.mSymbol = pSymbolValue.mSymbol;
    }

    public SymbolValue(String pSymbolName, Value pValue) {
        this.mSymbol = new Symbol(pSymbolName);
        this.setValue(pValue);
    }

    public final void addSymbolToMap(HashMap pMap, String pSymbolName) throws IllegalStateException {
        SymbolValue foundObject = (SymbolValue)pMap.get(pSymbolName);
        if (foundObject != null) {
            if (!foundObject.equals(this)) {
                throw new IllegalStateException("inconsistent object found with identical symbol names: " + pSymbolName + "; " + foundObject.getSymbol().getName());
            }
        } else {
            pMap.put(pSymbolName, this);
        }
    }

    public final void addSymbolToMap(HashMap pMap, String pSymbolName, ReservedSymbolMapper pReservedSymbolMapper) throws IllegalArgumentException, IllegalStateException {
        if (pReservedSymbolMapper != null && pReservedSymbolMapper.isReservedSymbol(this.getSymbol())) {
            throw new IllegalArgumentException("reserved symbol used: \"" + pSymbolName + "\"");
        }
        this.addSymbolToMap(pMap, pSymbolName);
    }

    public boolean equals(SymbolValue pSymbolValue) {
        return this.mValue.equals(pSymbolValue.mValue) && this.mSymbol.equals(pSymbolValue.mSymbol);
    }

    public final Value getValue() {
        return this.mValue;
    }

    public void setValue(Value pValue) {
        this.mValue = pValue;
    }

    public Symbol getSymbol() {
        return this.mSymbol;
    }

    public int compareTo(Object pObject) {
        return this.mSymbol.getName().compareTo(((SymbolValue)pObject).mSymbol.getName());
    }

    public Object clone() {
        SymbolValue retObj = new SymbolValue(this.mSymbol.getName(), (Value)this.mValue.clone());
        return retObj;
    }
}

