/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

import org.systemsbiology.math.Expression;
import org.systemsbiology.math.MutableDouble;
import org.systemsbiology.math.SymbolEvaluator;
import org.systemsbiology.util.DataNotFoundException;

public final class Value {
    private Expression mExpressionValue;
    private boolean mExpressionValueCached;
    private MutableDouble mNumericValue;

    public Value(Expression pExpressionValue) throws IllegalArgumentException {
        this.setValue(pExpressionValue);
    }

    public Value(double pNumericValue) {
        this.setValue(pNumericValue);
    }

    public Expression getExpressionValue() {
        return this.mExpressionValue;
    }

    public void setValue(double pValue) throws IllegalStateException {
        if (this.mNumericValue == null) {
            this.mNumericValue = new MutableDouble(pValue);
        } else {
            this.mNumericValue.setValue(pValue);
        }
        this.mExpressionValue = null;
        this.mExpressionValueCached = false;
    }

    public void setValue(Expression pExpressionValue) throws IllegalArgumentException {
        if (pExpressionValue == null) {
            throw new IllegalArgumentException("null expression object");
        }
        this.mExpressionValue = pExpressionValue;
        this.mExpressionValueCached = false;
        this.mNumericValue = new MutableDouble(0.0);
    }

    public double getValue() throws IllegalStateException {
        if (this.mExpressionValue == null) {
            return this.mNumericValue.doubleValue();
        }
        throw new IllegalStateException("this symbol value is an expression; must provide a SymbolValueMap");
    }

    public boolean isExpression() {
        return this.mExpressionValue != null;
    }

    public double getValueWithCaching(SymbolEvaluator pSymbolValueMap) throws DataNotFoundException {
        Expression expression = this.mExpressionValue;
        if (expression != null) {
            if (this.mExpressionValueCached) {
                return this.mNumericValue.mDouble;
            }
            double value = expression.computeValue(pSymbolValueMap);
            this.mExpressionValueCached = true;
            this.mNumericValue.setValue(value);
            return value;
        }
        return this.mNumericValue.mDouble;
    }

    public double getValue(SymbolEvaluator pSymbolValueMap) throws DataNotFoundException {
        Expression expression = this.mExpressionValue;
        if (expression != null) {
            double value = expression.computeValue(pSymbolValueMap);
            return value;
        }
        return this.mNumericValue.mDouble;
    }

    public String getExpressionString() throws IllegalStateException {
        if (!this.isExpression()) {
            throw new IllegalStateException("Value object does not have an Expression defined");
        }
        return this.mExpressionValue.toString();
    }

    public String getExpressionString(Expression.SymbolPrinter pSymbolPrinter) throws IllegalStateException, DataNotFoundException {
        if (!this.isExpression()) {
            throw new IllegalStateException("Value object does not have an Expression defined");
        }
        return this.mExpressionValue.toString(pSymbolPrinter);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isExpression()) {
            sb.append("\"");
            sb.append(this.mExpressionValue.toString());
            sb.append("\"");
        } else {
            sb.append(this.mNumericValue);
        }
        return sb.toString();
    }

    public void clearExpressionValueCache() {
        this.mExpressionValueCached = false;
    }

    public Object clone() {
        Value value = null;
        value = this.mExpressionValue != null ? new Value((Expression)this.mExpressionValue.clone()) : new Value(this.mNumericValue.doubleValue());
        return value;
    }
}

