/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import org.systemsbiology.math.probability.IContinuousDistribution;

public class DistributionPrinter {
    private static final double NUM_STDEVS = 6.0;

    public static String print(IContinuousDistribution pDist, int pNumSamples) {
        StringBuffer sb = new StringBuffer();
        String name = pDist.name();
        double min = pDist.domainMin();
        double max = pDist.domainMax();
        double mean = pDist.mean();
        double variance = pDist.variance();
        sb.append("name: " + name + "\n");
        sb.append("min: " + min + "\n");
        sb.append("max: " + max + "\n");
        sb.append("mean: " + mean + "\n");
        sb.append("variance: " + variance + "\n");
        double xstart = 0.0;
        double xstop = 0.0;
        double stdev = Math.sqrt(variance);
        if (Double.isInfinite(min)) {
            xstart = mean - 6.0 * stdev;
            xstop = mean + 6.0 * stdev;
        } else {
            xstart = min;
            xstop = !Double.isInfinite(mean) ? mean + 6.0 * stdev : min + 8.0 * stdev;
        }
        if (xstop > max) {
            xstop = max;
        }
        if (pNumSamples < 2) {
            throw new IllegalArgumentException("minimum number of samples is 2");
        }
        double deltax = (xstop - xstart) / (double)(pNumSamples - 1);
        double x = xstart;
        double pdfx = 0.0;
        int i = 0;
        while (i < pNumSamples) {
            pdfx = pDist.pdf(x);
            sb.append("pdf(" + x + ") = " + pdfx + "\n");
            x += deltax;
            if (x > max) {
                x = max;
            }
            ++i;
        }
        double cdfx = 0.0;
        x = xstart;
        int i2 = 0;
        while (i2 < pNumSamples) {
            cdfx = pDist.cdf(x);
            sb.append("cdf(" + x + ") = " + cdfx + "\n");
            x += deltax;
            if (x > max) {
                x = max;
            }
            ++i2;
        }
        return sb.toString();
    }
}

