/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import cern.colt.matrix.DoubleMatrix1D;
import org.systemsbiology.math.probability.IContinuousDistribution;

public class Empirical
implements IContinuousDistribution {
    private DoubleMatrix1D mDist;
    private double mMin;
    private double mMax;
    private double mMean;
    private double mVariance;

    public Empirical(DoubleMatrix1D pDist, double pMin, double pMax) {
        if (pMin >= pMax) {
            throw new IllegalArgumentException("max must exceed min");
        }
        this.mDist = pDist;
        int numBins = pDist.size();
        double binSize = (pMax - pMin) / (double)numBins;
        double mean = 0.0;
        double xk = 0.0;
        double yk = 0.0;
        int k = numBins;
        while (--k >= 0) {
            yk = pDist.get(k);
            xk = pMin + ((double)k + 0.5) * binSize;
            mean += yk * xk * binSize;
        }
        double variance = 0.0;
        int k2 = numBins;
        while (--k2 >= 0) {
            yk = pDist.get(k2);
            xk = pMin + ((double)k2 + 0.5) * binSize;
            variance += yk * (xk - mean) * (xk - mean) * binSize;
        }
        this.mMin = pMin;
        this.mMax = pMax;
        this.mMean = mean;
        this.mVariance = variance;
    }

    public double cdf(double x) {
        if (x <= this.mMin) {
            return 0.0;
        }
        if (x >= this.mMax) {
            return 1.0;
        }
        int numBins = this.mDist.size();
        double binSize = (this.mMax - this.mMin) / (double)numBins;
        double Nmaxdouble = (x - this.mMin) / binSize;
        int Nmax = (int)Nmaxdouble;
        if (Nmax == numBins) {
            --Nmax;
        }
        double cumSum = 0.0;
        int k = 0;
        k = 0;
        while (k < Nmax) {
            cumSum += this.mDist.get(k) * binSize;
            ++k;
        }
        double remainder = Nmaxdouble - (double)Nmax;
        if (remainder > 0.0) {
            cumSum += remainder * this.mDist.get(k) * binSize;
        }
        return cumSum;
    }

    public double pdf(double x) {
        int numBins = this.mDist.size();
        if (x < this.mMin || x > this.mMax) {
            throw new IllegalArgumentException("out of bounds value for x; x: " + x + "; min: " + this.mMin + "; max: " + this.mMax);
        }
        double binSize = (this.mMax - this.mMin) / (double)numBins;
        int k = (int)((x - this.mMin) / binSize + 0.5);
        if (k == 0) {
            return this.mDist.get(0);
        }
        double yleft = this.mDist.get(k - 1);
        double yright = 0.0;
        double xleft = this.mMin + ((double)k - 0.5) * binSize;
        double xright = 0.0;
        if (k < numBins) {
            yright = this.mDist.get(k);
            xright = xleft + binSize;
        } else {
            yright = 0.0;
            xright = this.mMax;
        }
        double slope = (yright - yleft) / (xright - xleft);
        double retVal = yleft + slope * (x - xleft);
        if (retVal < 0.0) {
            retVal = 0.0;
        }
        return retVal;
    }

    public double mean() {
        return this.mMean;
    }

    public double domainMin() {
        return this.mMin;
    }

    public double domainMax() {
        return this.mMax;
    }

    public double variance() {
        return this.mVariance;
    }

    public String name() {
        return "Empirical";
    }
}

