/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import cern.jet.stat.Probability;
import org.systemsbiology.math.probability.IContinuousDistribution;

public class Gamma
implements IContinuousDistribution {
    private static final double THRESHOLD_USE_STIRLINGS_APPROXIMATION = 6.0;
    private double mAlpha;
    private double mTheta;

    public Gamma(double pMean, double pVariance) {
        this.mAlpha = pMean * pMean / pVariance;
        this.mTheta = pMean / this.mAlpha;
    }

    public double mean() {
        return this.mTheta * this.mAlpha;
    }

    public double pdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("x value out of range");
        }
        double retVal = 0.0;
        if (this.mAlpha < 6.0) {
            retVal = Math.pow(x, this.mAlpha - 1.0) * Math.exp(-1.0 * x / this.mTheta) / (Math.pow(this.mTheta, this.mAlpha) * cern.jet.stat.Gamma.gamma((double)this.mAlpha));
        } else {
            double xDivTheta = x / this.mTheta;
            double alphaMinus1 = this.mAlpha - 1.0;
            retVal = Math.pow(Math.PI * (2.0 * alphaMinus1 + 0.3333333333333333), -0.5) * Math.pow(xDivTheta / alphaMinus1, alphaMinus1) * Math.exp(alphaMinus1 - xDivTheta) / this.mTheta;
        }
        return retVal;
    }

    public double cdf(double x) {
        return Probability.gamma((double)(1.0 / this.mTheta), (double)this.mAlpha, (double)x);
    }

    public double domainMin() {
        return 0.0;
    }

    public double domainMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double variance() {
        return this.mAlpha * this.mTheta * this.mTheta;
    }

    public String name() {
        return "Gamma";
    }
}

