/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import org.systemsbiology.math.probability.IContinuousDistribution;
import org.systemsbiology.math.probability.Lorentz;

public class HalfLorentz
implements IContinuousDistribution {
    private double mWidth;

    public HalfLorentz(double pStdev) {
        this.mWidth = 0.5 * pStdev;
    }

    public double pdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("x value out of range");
        }
        return 2.0 * Lorentz.pdf(0.0, this.mWidth, x);
    }

    public double cdf(double x) {
        return 2.0 * Lorentz.cdf(0.0, this.mWidth, x) - 1.0;
    }

    public double domainMin() {
        return 0.0;
    }

    public double domainMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double mean() {
        return Double.POSITIVE_INFINITY;
    }

    public double variance() {
        return this.mWidth * this.mWidth;
    }

    public String name() {
        return "HalfLorentz";
    }
}

