/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import cern.jet.stat.Probability;
import org.systemsbiology.math.probability.IContinuousDistribution;
import org.systemsbiology.math.probability.Normal;

public class HalfNormal
implements IContinuousDistribution {
    private double mTheta;

    public HalfNormal(double pMean) {
        if (pMean <= 0.0) {
            throw new IllegalArgumentException("mean value out of range");
        }
        this.mTheta = 1.0 / pMean;
    }

    public double pdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("x value out of range");
        }
        return 2.0 * Normal.pdf(0.0, Math.PI / (2.0 * this.mTheta * this.mTheta), x);
    }

    public double cdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("x value out of range");
        }
        return 2.0 * (Probability.normal((double)0.0, (double)(Math.PI / (2.0 * this.mTheta * this.mTheta)), (double)x) - 0.5);
    }

    public double domainMin() {
        return 0.0;
    }

    public double domainMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double mean() {
        return 1.0 / this.mTheta;
    }

    public double variance() {
        return 1.1415926535897931 / (2.0 * this.mTheta * this.mTheta);
    }

    public String name() {
        return "HalfNormal";
    }
}

