/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import org.systemsbiology.math.MathFunctions;
import org.systemsbiology.math.probability.IContinuousDistribution;

public class Laplace
implements IContinuousDistribution {
    private double mMean;
    private double mB;

    public Laplace(double pMean, double pVariance) {
        this.mMean = pMean;
        if (pVariance <= 0.0) {
            throw new IllegalArgumentException("invalid variance");
        }
        this.mB = Math.sqrt(pVariance / 2.0);
    }

    public double pdf(double x) {
        return Math.exp(-1.0 * Math.abs(x - this.mMean) / this.mB) / (2.0 * this.mB);
    }

    public double cdf(double x) {
        return 0.5 * (1.0 + MathFunctions.sign(x - this.mMean) * (1.0 - Math.exp(-1.0 * Math.abs(x - this.mMean) / this.mB)));
    }

    public double domainMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double domainMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double mean() {
        return this.mMean;
    }

    public double variance() {
        return 2.0 * this.mB * this.mB;
    }

    public String name() {
        return "Laplace";
    }
}

