/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import org.systemsbiology.math.probability.IContinuousDistribution;

public class Logistic
implements IContinuousDistribution {
    private double mB;
    private double mM;

    public Logistic(double pMean, double pVariance) {
        this.mM = pMean;
        if (pVariance <= 0.0) {
            throw new IllegalArgumentException("invalid variance");
        }
        this.mB = Math.sqrt(3.0 * pVariance) / Math.PI;
    }

    public double pdf(double x) {
        double tau = Math.exp((this.mM - x) / this.mB);
        return tau / ((1.0 + tau) * (1.0 + tau) * this.mB);
    }

    public double cdf(double x) {
        return 1.0 / (1.0 + Math.exp(-1.0 * (x - this.mM) / this.mB));
    }

    public double domainMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double domainMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double mean() {
        return this.mM;
    }

    public double variance() {
        return this.mB * this.mB * Math.PI * Math.PI / 3.0;
    }

    public String name() {
        return "Logistic";
    }
}

