/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import org.systemsbiology.math.probability.IContinuousDistribution;

public class Lorentz
implements IContinuousDistribution {
    private double mWidth;
    private double mMean;
    public static final double RATIO_WIDTH_TO_STDEV = 0.5;

    public static double pdf(double pMean, double pWidth, double x) {
        return pWidth / (Math.PI * 2 * ((x - pMean) * (x - pMean) + pWidth * pWidth / 4.0));
    }

    public static double cdf(double pMean, double pWidth, double x) {
        return 0.5 + Math.atan(2.0 * (x - pMean) / pWidth) / Math.PI;
    }

    public Lorentz(double pMean, double pStdev) {
        this.mMean = pMean;
        this.mWidth = 0.5 * pStdev;
    }

    public double pdf(double x) {
        return Lorentz.pdf(this.mMean, this.mWidth, x);
    }

    public double cdf(double x) {
        return Lorentz.cdf(this.mMean, this.mWidth, x);
    }

    public double domainMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double domainMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double mean() {
        return 0.0;
    }

    public double variance() {
        return this.mWidth * this.mWidth;
    }

    public String name() {
        return "Lorentz";
    }
}

