/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import cern.jet.stat.Gamma;
import org.systemsbiology.math.probability.IContinuousDistribution;

public class Maxwell
implements IContinuousDistribution {
    private double mA;

    public Maxwell(double pMean) {
        if (pMean <= 0.0) {
            throw new IllegalArgumentException("invalid mean");
        }
        this.mA = 8.0 / (Math.PI * pMean * pMean);
    }

    public double cdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("x value out of range");
        }
        return Gamma.incompleteGamma((double)1.5, (double)(0.5 * this.mA * x * x));
    }

    public double pdf(double x) {
        return Math.sqrt(0.6366197723675814) * Math.pow(this.mA, 1.5) * x * x * Math.exp(-1.0 * this.mA * x * x / 2.0);
    }

    public double domainMin() {
        return 0.0;
    }

    public double domainMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double mean() {
        return Math.sqrt(8.0 / (Math.PI * this.mA));
    }

    public double variance() {
        return 1.4247779607693793 / (Math.PI * this.mA);
    }

    public String name() {
        return "Maxwell";
    }
}

