/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import cern.jet.stat.Probability;
import org.systemsbiology.math.probability.IContinuousDistribution;

public class Normal
implements IContinuousDistribution {
    private double mMean;
    private double mVariance;

    public static double pdf(double pMean, double pVariance, double x) {
        return Math.exp(-1.0 * (x - pMean) * (x - pMean) / (2.0 * pVariance)) / Math.sqrt(Math.PI * 2 * pVariance);
    }

    public static double cdf(double pMean, double pVariance, double x) {
        return Probability.normal((double)pMean, (double)pVariance, (double)x);
    }

    public Normal(double pMean, double pVariance) {
        this.mMean = pMean;
        this.mVariance = pVariance;
    }

    public double pdf(double x) {
        return Normal.pdf(this.mMean, this.mVariance, x);
    }

    public double cdf(double x) {
        return Probability.normal((double)this.mMean, (double)this.mVariance, (double)x);
    }

    public double domainMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double domainMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double mean() {
        return this.mMean;
    }

    public double variance() {
        return this.mVariance;
    }

    public String name() {
        return "Normal";
    }
}

