/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math.probability;

import org.systemsbiology.math.probability.IContinuousDistribution;

public class Rayleigh
implements IContinuousDistribution {
    private double mS;

    public Rayleigh(double pMean) {
        if (pMean <= 0.0) {
            throw new IllegalArgumentException("invalid mean");
        }
        this.mS = pMean * Math.sqrt(0.6366197723675814);
    }

    public double pdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("x value out of range: " + x);
        }
        return x * Math.exp(-1.0 * x * x / (2.0 * this.mS * this.mS)) / (this.mS * this.mS);
    }

    public double cdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("x value out of range");
        }
        return 1.0 - Math.exp(-1.0 * x * x / (2.0 * this.mS * this.mS));
    }

    public double domainMin() {
        return 0.0;
    }

    public double domainMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double mean() {
        return this.mS * Math.sqrt(1.5707963267948966);
    }

    public double variance() {
        return 0.8584073464102069 * this.mS * this.mS / 2.0;
    }

    public String name() {
        return "Rayleigh";
    }
}

