/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.FileUtils;
import org.systemsbiology.util.InvalidInputException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AppConfig {
    private Document mConfigFileDocument;
    private String mSourceURI;
    private static final String PROPERTY_NAME_APP_NAME = "appName";
    private static final String PROPERTY_NAME_APP_DATE = "appDate";
    private static final String PROPERTY_NAME_APP_VERSION = "appVersion";
    private static final String PROPERTY_NAME_APP_ICON_URL = "appIconURL";
    private static final String PROPERTY_NAME_APP_HOME_PAGE = "appHomePage";
    private static final String PROPERTY_NAME_APP_HELP_SET_NAME = "appHelpSetName";
    private static final String PROPERTY_NAME_APP_MAINTAINER_FULL_NAME = "appMaintainerFullName";
    private static final String PROPERTY_NAME_APP_COPYRIGHT = "appCopyright";
    public static final String CONFIG_FILE_NAME = "AppConfig.xml";

    public AppConfig(File pConfigFile) throws InvalidInputException, DataNotFoundException, FileNotFoundException {
        this(AppConfig.getConfigSource(pConfigFile));
    }

    private AppConfig(InputSource pInputSource) throws InvalidInputException, DataNotFoundException {
        try {
            Document document;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.mConfigFileDocument = document = builder.parse(pInputSource);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new InvalidInputException("unable to load XML configuration file", e);
        }
    }

    public AppConfig(Class pAppClass) throws InvalidInputException, DataNotFoundException {
        this(AppConfig.getConfigSource(pAppClass));
    }

    private static InputSource getConfigSource(File pAppFile) throws FileNotFoundException {
        InputSource retSource = null;
        String uri = FileUtils.createFileURL(pAppFile);
        FileInputStream fileInputStream = new FileInputStream(pAppFile);
        retSource = new InputSource(fileInputStream);
        retSource.setSystemId(uri);
        return retSource;
    }

    private static InputSource getConfigSource(Class pAppClass) throws DataNotFoundException {
        URL resource = pAppClass.getResource(CONFIG_FILE_NAME);
        String resourceFileName = resource.toExternalForm();
        File resourceFile = new File(resourceFileName);
        InputStream configResourceStream = pAppClass.getResourceAsStream(CONFIG_FILE_NAME);
        if (configResourceStream == null) {
            throw new DataNotFoundException("unable to find XML configuration file resource: AppConfig.xml for class: " + pAppClass.getName());
        }
        InputSource inputSource = new InputSource(configResourceStream);
        if (!resourceFile.exists()) {
            inputSource.setSystemId(resourceFileName);
        }
        return inputSource;
    }

    public String getProperty(String pPropertyName) {
        Node firstChildNode;
        String propertyValue = null;
        NodeList nodeList = this.mConfigFileDocument.getElementsByTagName(pPropertyName);
        int nodeListLength = nodeList.getLength();
        if (nodeListLength > 0 && (firstChildNode = nodeList.item(nodeListLength - 1).getFirstChild()) != null) {
            propertyValue = firstChildNode.getNodeValue();
        }
        return propertyValue;
    }

    public String getAppHomePage() {
        return this.getProperty(PROPERTY_NAME_APP_HOME_PAGE);
    }

    public String getAppName() {
        return this.getProperty(PROPERTY_NAME_APP_NAME);
    }

    public String getAppVersion() {
        return this.getProperty(PROPERTY_NAME_APP_VERSION);
    }

    public String getAppDate() {
        return this.getProperty(PROPERTY_NAME_APP_DATE);
    }

    public String getAppIconURL() {
        return this.getProperty(PROPERTY_NAME_APP_ICON_URL);
    }

    public String getAppHelpSetName() {
        return this.getProperty(PROPERTY_NAME_APP_HELP_SET_NAME);
    }

    public String getAppMaintainerFullName() {
        return this.getProperty(PROPERTY_NAME_APP_MAINTAINER_FULL_NAME);
    }

    public String getAppCopyright() {
        return this.getProperty(PROPERTY_NAME_APP_COPYRIGHT);
    }

    public static AppConfig get(Class pAppClass, String pAppDir) throws DataNotFoundException, InvalidInputException, FileNotFoundException {
        AppConfig appConfig = null;
        if (pAppDir == null) {
            appConfig = new AppConfig(pAppClass);
        } else {
            File appDirFile = new File(pAppDir);
            if (!appDirFile.exists()) {
                throw new DataNotFoundException("could not find application directory: " + pAppDir);
            }
            String configFileName = String.valueOf(appDirFile.getAbsolutePath()) + "/config/" + CONFIG_FILE_NAME;
            appConfig = new AppConfig(new File(configFileName));
        }
        return appConfig;
    }

    public static void main(String[] pArgs) {
        try {
            AppConfig appConfig = new AppConfig(new File(pArgs[0]));
            System.out.println("version: " + appConfig.getAppVersion());
            System.out.println("appname: " + appConfig.getAppName());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

