/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;

public class ClassRegistry {
    private static final String FIELD_NAME_CLASS_ALIAS = "CLASS_ALIAS";
    private static final String MANIFEST_DIR_NAME = "META-INF";
    private static HashSet sAliasableClasses = null;
    private static final String PACKAGE_ROOT = "org.systemsbiology";
    private Class mInterface;
    private HashMap mRegistry;
    private HashMap mInstances;

    private void setInstances(HashMap pInstances) {
        this.mInstances = pInstances;
    }

    private HashMap getInstances() {
        return this.mInstances;
    }

    private void setInterface(Class pInterface) {
        this.mInterface = pInterface;
    }

    private Class getInterface() {
        return this.mInterface;
    }

    private void setRegistry(HashMap pRegistry) {
        this.mRegistry = pRegistry;
    }

    private HashMap getRegistry() {
        return this.mRegistry;
    }

    public ClassRegistry(Class pInterface) throws IllegalArgumentException {
        this.checkInterface(pInterface);
        this.setInterface(pInterface);
        this.setRegistry(new HashMap());
        this.setInstances(new HashMap());
    }

    private void registerClassIfImplementingInterface(String pClassName, Class pInterface, HashMap pRegistry) throws IOException, IllegalArgumentException {
        Class<?> theClass = null;
        try {
            theClass = this.getClass().getClassLoader().loadClass(pClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("class file is not a valid class: " + pClassName);
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println("class definition not found: " + pClassName);
            return;
        }
        if (theClass.isInterface()) {
            return;
        }
        if (pInterface.isAssignableFrom(theClass)) {
            String className = theClass.getName();
            Field aliasField = null;
            try {
                aliasField = theClass.getDeclaredField(FIELD_NAME_CLASS_ALIAS);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                System.err.println("CLASS_ALIAS field does not exist in class: " + className);
                return;
            }
            String classAlias = null;
            try {
                classAlias = (String)aliasField.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("CLASS_ALIAS field is not public in class: " + className);
                return;
            }
            String foundClassName = (String)pRegistry.get(classAlias);
            if (foundClassName != null && !foundClassName.equals(className)) {
                System.err.println("two classes are found to have the same class alias \"" + classAlias + "\"; first class is: \"" + foundClassName + "\"; second class is \"" + className + "\"; ignoring second class");
            }
            pRegistry.put(classAlias, className);
        }
    }

    private boolean classImplementsInterface(String pClassName, Class pInterface) {
        boolean retVal = false;
        Class<?> theClass = null;
        try {
            theClass = this.getClass().getClassLoader().loadClass(pClassName);
            if (!theClass.isInterface() && pInterface.isAssignableFrom(theClass)) {
                retVal = true;
            }
        }
        catch (Throwable throwable) {
            System.err.println("warning:  there is a problem with class file \"" + pClassName + "\"");
        }
        return retVal;
    }

    private void searchForClassesImplementingInterface(String pPackageName, HashSet pPackagesAlreadySearched, Class pInterface, HashSet pClassesImplementingInterface) throws IOException, IllegalArgumentException {
        block13: {
            URL url;
            block14: {
                String resourceName = pPackageName.replace('.', '/');
                if (!resourceName.startsWith("/")) {
                    resourceName = "/" + resourceName;
                }
                if (resourceName.endsWith("/")) {
                    resourceName = resourceName.substring(0, resourceName.length() - 1);
                }
                assert (!resourceName.endsWith("/")) : "resource name ended with slash: " + resourceName;
                url = ClassRegistry.class.getResource(resourceName);
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                if (url == null && (url = pInterface.getResource(resourceName)) == null) {
                    url = systemClassLoader.getResource(resourceName);
                }
                if (url == null) break block13;
                File directory = new File(url.getFile());
                String directoryName = directory.getAbsolutePath();
                if (!directory.exists()) break block14;
                String[] files = directory.list();
                int numFiles = files.length;
                int fileCtr = 0;
                while (fileCtr < numFiles) {
                    block15: {
                        String fileName;
                        block16: {
                            fileName = files[fileCtr];
                            if (fileName.equals("CVS")) break block15;
                            String fullFileName = String.valueOf(directoryName) + "/" + fileName;
                            File subFile = new File(fullFileName);
                            if (!subFile.isDirectory()) break block16;
                            String subPackageResourceName = String.valueOf(resourceName) + "/" + fileName;
                            String subPackageName = subPackageResourceName.substring(1, subPackageResourceName.length()).replace('/', '.');
                            if (pPackagesAlreadySearched.contains(subPackageName)) break block15;
                            pPackagesAlreadySearched.add(subPackageName);
                            this.searchForClassesImplementingInterface(subPackageName, pPackagesAlreadySearched, pInterface, pClassesImplementingInterface);
                        }
                        if (fileName.endsWith(".class")) {
                            String packageName = null;
                            packageName = resourceName.startsWith("/") ? resourceName.substring(1, resourceName.length()) : resourceName;
                            String className = String.valueOf(packageName = packageName.replace('/', '.')) + "." + fileName.substring(0, fileName.length() - 6);
                            if (!pClassesImplementingInterface.contains(className) && this.classImplementsInterface(className, pInterface)) {
                                pClassesImplementingInterface.add(className);
                            }
                        }
                    }
                    ++fileCtr;
                }
                break block13;
            }
            URLConnection uconn = url.openConnection();
            if (!(uconn instanceof JarURLConnection)) break block13;
            JarURLConnection conn = (JarURLConnection)uconn;
            String starts = conn.getEntryName();
            JarFile jfile = conn.getJarFile();
            Enumeration<JarEntry> e = jfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (entryName.endsWith("/")) {
                    String subPackageName;
                    if (entryName.equals("META-INF/") || pPackagesAlreadySearched.contains(subPackageName = entryName.replace('/', '.'))) continue;
                    pPackagesAlreadySearched.add(subPackageName);
                    this.searchForClassesImplementingInterface(subPackageName, pPackagesAlreadySearched, pInterface, pClassesImplementingInterface);
                }
                if (!entryName.startsWith(starts) || entryName.lastIndexOf(47) > starts.length() || !entryName.endsWith(".class")) continue;
                String classname = entryName.substring(0, entryName.length() - 6);
                if (classname.startsWith("/")) {
                    classname = classname.substring(1);
                }
                if (pClassesImplementingInterface.contains(classname = classname.replace('/', '.')) || !this.classImplementsInterface(classname, pInterface)) continue;
                pClassesImplementingInterface.add(classname);
            }
        }
    }

    private void searchForClassesImplementingInterface(HashSet pPackagesAlreadySearched, Class pInterface, HashSet pClassesImplementingInterface) throws IOException {
        Package[] packages = Package.getPackages();
        int numPackages = packages.length;
        int packageCtr = 0;
        while (packageCtr < numPackages) {
            Package thePackage = packages[packageCtr];
            String packageName = thePackage.getName();
            this.searchForClassesImplementingInterface(packageName, pPackagesAlreadySearched, pInterface, pClassesImplementingInterface);
            ++packageCtr;
        }
    }

    private void checkInterface(Class pInterface) throws IllegalArgumentException {
        if (!pInterface.isInterface()) {
            throw new IllegalArgumentException("class argument is not an interface: " + pInterface.getName());
        }
    }

    public void buildRegistry() throws ClassNotFoundException, IOException, IllegalArgumentException {
        if (sAliasableClasses == null) {
            sAliasableClasses = new HashSet();
            Class<IAliasableClass> aliasableClassesInterfaceClass = IAliasableClass.class;
            HashSet packagesAlreadySearched = new HashSet();
            this.searchForClassesImplementingInterface(packagesAlreadySearched, aliasableClassesInterfaceClass, sAliasableClasses);
            this.searchForClassesImplementingInterface(PACKAGE_ROOT, packagesAlreadySearched, aliasableClassesInterfaceClass, sAliasableClasses);
        }
        Iterator classNamesIter = sAliasableClasses.iterator();
        HashMap registry = this.getRegistry();
        Class targetInterface = this.getInterface();
        while (classNamesIter.hasNext()) {
            String className = (String)classNamesIter.next();
            this.registerClassIfImplementingInterface(className, targetInterface, registry);
        }
    }

    public Class getClass(String pClassAlias) throws DataNotFoundException {
        Class<?> retClass;
        block3: {
            HashMap registry = this.getRegistry();
            String className = (String)registry.get(pClassAlias);
            if (className == null) {
                throw new DataNotFoundException("unable to locate class for alias: " + pClassAlias);
            }
            retClass = null;
            try {
                retClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)new String("class not found for classname: " + className));
            }
        }
        return retClass;
    }

    public Object getInstance(String pClassAlias) throws DataNotFoundException {
        HashMap registry = this.getRegistry();
        String buildClassName = (String)registry.get(pClassAlias);
        Class interfaceClass = this.getInterface();
        if (buildClassName == null) {
            throw new DataNotFoundException("unable to find class implementing interface \"" + interfaceClass.getName() + "\" with alias \"" + pClassAlias + "\"");
        }
        Class<?> buildClass = null;
        try {
            buildClass = Class.forName(buildClassName);
        }
        catch (ClassNotFoundException e) {
            throw new DataNotFoundException("unable to find class " + buildClassName, e);
        }
        assert (interfaceClass.isAssignableFrom(buildClass)) : new String("error in class registry; interface class " + interfaceClass.getName() + " is not assignable from build class: " + buildClassName);
        HashMap instances = this.getInstances();
        Object instance = instances.get(buildClassName);
        if (instance == null) {
            try {
                instance = buildClass.newInstance();
            }
            catch (Exception e) {
                throw new DataNotFoundException("unable to instantiate class " + buildClassName, e);
            }
            instances.put(buildClassName, instance);
        }
        return instance;
    }

    public void printRegistry(PrintStream pStream) {
        HashMap registry = this.getRegistry();
        Set aliases = registry.keySet();
        for (String alias : aliases) {
            String className = (String)registry.get(alias);
            pStream.println(String.valueOf(alias) + " -> " + className);
        }
    }

    public Set getRegistryAliasesCopy() {
        HashSet<String> newRegistryAliases = new HashSet<String>();
        Set registryAliases = this.getRegistry().keySet();
        for (String alias : registryAliases) {
            newRegistryAliases.add(alias);
        }
        return newRegistryAliases;
    }

    public void clearInstances() {
        HashMap instances = this.getInstances();
        instances.clear();
    }

    public static void main(String[] pArgs) {
        try {
            ClassRegistry classRegistry = new ClassRegistry(Class.forName(pArgs[0]));
            classRegistry.buildRegistry();
            classRegistry.printRegistry(System.out);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

