/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.util;

import java.io.OutputStream;

public abstract class CommandLineApp {
    protected static final String HELP_ARG = "-help";
    public static final String NULL_MODIFIER = "null";

    protected abstract void printUsage(OutputStream var1);

    protected void handleCommandLineError(String pMessage) {
        System.err.println(pMessage);
        System.err.println("Please refer to the usage description that follows: ");
        this.printUsage(System.err);
        System.exit(1);
    }

    protected String getRequiredArgumentModifier(String pArgument, String[] pArgs, int pCtr) {
        if (pCtr == pArgs.length) {
            this.handleCommandLineError("argument \"" + pArgument + "\" has a required element after it; please refer to the usage description that follows\n");
        }
        return pArgs[pCtr];
    }

    protected Double getRequiredDoubleArgumentModifier(String pArgument, String[] pArgs, int pCtr) {
        String valueString = this.getRequiredArgumentModifier(pArgument, pArgs, pCtr);
        if (valueString.equals(NULL_MODIFIER)) {
            return null;
        }
        Double retVal = null;
        try {
            retVal = Double.valueOf(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            this.handleCommandLineError("invalid floating-point value for argument \"" + pArgument + "\"; value was: " + valueString);
        }
        return retVal;
    }

    protected Integer getRequiredIntegerArgumentModifier(String pArgument, String[] pArgs, int pCtr) {
        String valueString = this.getRequiredArgumentModifier(pArgument, pArgs, pCtr);
        if (valueString.equals(NULL_MODIFIER)) {
            return null;
        }
        Integer retVal = null;
        try {
            retVal = Integer.valueOf(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            this.handleCommandLineError("invalid integer value for argument \"" + pArgument + "\"; value was: " + valueString);
        }
        return retVal;
    }

    protected Long getRequiredLongArgumentModifier(String pArgument, String[] pArgs, int pCtr) {
        String valueString = this.getRequiredArgumentModifier(pArgument, pArgs, pCtr);
        if (valueString.equals(NULL_MODIFIER)) {
            return null;
        }
        Long retVal = null;
        try {
            retVal = Long.valueOf(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            this.handleCommandLineError("invalid long value for argument \"" + pArgument + "\"; value was: " + valueString);
        }
        return retVal;
    }

    protected void checkAndHandleHelpRequest(String[] pArgs) {
        int numArgs = pArgs.length;
        int argCtr = 0;
        while (argCtr < numArgs) {
            String arg = pArgs[argCtr];
            if (arg.equals(HELP_ARG)) {
                this.printUsage(System.out);
                System.exit(0);
            }
            ++argCtr;
        }
    }

    protected abstract void handleCommandLine(String[] var1);
}

