/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;

public class DebugUtils {
    private static boolean sDebug = false;

    public static void setDebug(boolean pDebug) {
        sDebug = pDebug;
    }

    public static boolean getDebug() {
        return sDebug;
    }

    public static void printDoubleVector(double[] pVec) {
        int numElements = pVec.length;
        int ctr = 0;
        while (ctr < numElements) {
            System.out.println("index: " + ctr + "; value: " + pVec[ctr]);
            ++ctr;
        }
    }

    public static void describeSortedObjectList(StringBuffer pStringBuffer, HashMap pObjectMap, Class pClassTypeFilter) {
        String separatorString = ", ";
        DebugUtils.describeSortedObjectList(pStringBuffer, pObjectMap, pClassTypeFilter, separatorString);
    }

    public static void describeSortedObjectList(StringBuffer pStringBuffer, HashMap pObjectMap, String pSeparatorString) {
        Class classTypeFilter = null;
        DebugUtils.describeSortedObjectList(pStringBuffer, pObjectMap, classTypeFilter, pSeparatorString);
    }

    public static void describeSortedObjectList(StringBuffer pStringBuffer, HashMap pObjectMap) {
        String separatorString = ", ";
        Class classTypeFilter = null;
        DebugUtils.describeSortedObjectList(pStringBuffer, pObjectMap, classTypeFilter, separatorString);
    }

    public static void describeSortedObjectList(StringBuffer pStringBuffer, HashMap pObjectMap, Class pClassTypeFilter, String pSeparatorString) {
        LinkedList objectList = new LinkedList(pObjectMap.values());
        Collections.sort(objectList);
        ListIterator iter = objectList.listIterator();
        StringBuffer sb = pStringBuffer;
        sb.append("{\n");
        boolean first = true;
        while (iter.hasNext()) {
            Object object = iter.next();
            if (pClassTypeFilter != null && !object.getClass().isAssignableFrom(pClassTypeFilter)) continue;
            if (!first) {
                sb.append(pSeparatorString);
            } else {
                first = false;
            }
            sb.append(object.toString());
        }
        sb.append("\n}");
    }
}

