/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FileUtils {
    public static void fileCopy(String fromPath, String toPath) throws IOException {
        int c;
        File inputFile = new File(fromPath);
        File outputFile = new File(toPath);
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static String getFileName(String pathToFile) {
        int fileNameStartPos = pathToFile.lastIndexOf("/");
        if (fileNameStartPos == -1) {
            fileNameStartPos = pathToFile.lastIndexOf(String.valueOf('\\'));
        }
        String fileName = pathToFile.substring(fileNameStartPos);
        return fileName;
    }

    public static String addSuffixToFilename(String pFileName, String pSuffix) {
        int lastIndex = pFileName.lastIndexOf(46);
        String retVal = null;
        retVal = -1 != lastIndex ? String.valueOf(pFileName.substring(0, lastIndex)) + pSuffix : String.valueOf(pFileName) + pSuffix;
        return retVal;
    }

    public static String getExtension(String pFileName) {
        int lastIndex = pFileName.lastIndexOf(46);
        String retExtension = null;
        if (-1 != lastIndex) {
            retExtension = pFileName.substring(lastIndex + 1, pFileName.length());
        }
        return retExtension;
    }

    public static String removeExtension(String pFileName) {
        int lastIndex = pFileName.lastIndexOf(46);
        String retFileName = pFileName;
        if (-1 != lastIndex) {
            retFileName = pFileName.substring(0, lastIndex);
        }
        return retFileName;
    }

    public static String fixWindowsCommandLineDirectoryNameMangling(String pDirName) {
        String retString = pDirName;
        if (retString.endsWith("\"") && !(retString = retString.substring(0, retString.length() - 1)).endsWith(File.separator) && !retString.endsWith("\\") && !retString.endsWith("/")) {
            retString = String.valueOf(retString) + File.separator;
        }
        return retString;
    }

    public static String createFileURL(File pFile) {
        String fileName = pFile.getAbsolutePath();
        if ((fileName = fileName.replace(File.separatorChar, '/')).charAt(0) != '/') {
            fileName = "/" + fileName;
        }
        fileName = fileName.replaceAll("%", "%25");
        fileName = fileName.replaceAll(" ", "%20");
        fileName = fileName.replaceAll("\\:", "%3A");
        fileName = fileName.replaceAll("#", "%23");
        fileName = fileName.replaceAll("\\$", "%24");
        fileName = fileName.replaceAll("&", "%26");
        fileName = fileName.replaceAll("\\?", "%3F");
        fileName = fileName.replaceAll("@", "%40");
        fileName = fileName.replaceAll(";", "%3B");
        fileName = fileName.replaceAll(",", "%2C");
        fileName = fileName.replaceAll("\\+", "%2C");
        fileName = fileName.replaceAll("<", "%3C");
        fileName = fileName.replaceAll(">", "%3E");
        fileName = fileName.replaceAll("\"", "%34");
        return "file:" + fileName;
    }
}

