/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashSet;

public class IncludeHandler {
    private HashSet mIncludedFiles;
    private File mDirectory;

    public File getDirectory() {
        return this.mDirectory;
    }

    public void setDirectory(File pDirectory) throws IllegalArgumentException {
        if (pDirectory != null && !pDirectory.isDirectory()) {
            throw new IllegalArgumentException("specified pathname is not a directory: " + pDirectory.getAbsolutePath());
        }
        this.mDirectory = pDirectory;
    }

    private HashSet getIncludedFiles() {
        return this.mIncludedFiles;
    }

    private void setIncludedFiles(HashSet pIncludedFiles) {
        this.mIncludedFiles = pIncludedFiles;
    }

    private boolean alreadyParsedFile(String pFileName) {
        return this.getIncludedFiles().contains(pFileName);
    }

    private void storeParsedFile(String pFileName) {
        this.getIncludedFiles().add(pFileName);
    }

    public IncludeHandler() {
        this.setIncludedFiles(new HashSet());
        this.setDirectory(null);
    }

    public String getIncludeFileAbsolutePath(String pIncludeFileName) throws IOException {
        File dirFile;
        File includeFile = new File(pIncludeFileName);
        String includeFileAbsolutePath = null;
        includeFileAbsolutePath = !includeFile.isAbsolute() ? ((dirFile = this.getDirectory()) != null ? String.valueOf(dirFile.getAbsolutePath()) + File.separator + pIncludeFileName : new File(pIncludeFileName).getAbsolutePath()) : includeFile.getAbsolutePath();
        return includeFileAbsolutePath;
    }

    public BufferedReader openReaderForIncludeFile(String pIncludedFileName, Charset pCharset) throws IOException {
        String includeFileAbsolutePath = this.getIncludeFileAbsolutePath(pIncludedFileName);
        BufferedReader bufferedReader = null;
        if (!this.alreadyParsedFile(includeFileAbsolutePath)) {
            this.storeParsedFile(includeFileAbsolutePath);
            File includeFile = new File(includeFileAbsolutePath);
            FileInputStream fileInputStream = new FileInputStream(includeFile);
            InputStreamReader inputStreamReader = null;
            inputStreamReader = pCharset != null ? new InputStreamReader((InputStream)fileInputStream, pCharset) : new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        return bufferedReader;
    }

    public boolean isWithinIncludeFile() {
        return this.getIncludedFiles().size() > 1;
    }
}

