/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import uk.ac.ed.inf.biopepa.core.BioPEPA;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.dom.Model;
import uk.ac.ed.inf.biopepa.core.dom.internal.ParserException;
import uk.ac.ed.inf.biopepa.core.interfaces.ProgressMonitor;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.interfaces.Solver;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.ui.BioPEPAEvent;
import uk.ac.ed.inf.biopepa.ui.BioPEPAPlugin;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAListener;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;

public class BioPEPAModelImpl
implements BioPEPAModel {
    Model astModel = null;
    ModelCompiler compiledModel = null;
    private List<BioPEPAListener> listeners = new ArrayList<BioPEPAListener>();
    Map<QualifiedName, String> metaData = new HashMap<QualifiedName, String>();
    ProblemInfo[] problems;
    IResource resource = null;
    List<IMarker> markers = new ArrayList<IMarker>();
    Runnable bringProblemsToView = new Runnable(){

        public void run() {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView");
            }
            catch (Exception exception) {}
        }
    };
    SBAModel sbaModel = null;

    BioPEPAModelImpl(IResource resource) {
        this.resource = resource;
    }

    public void addListener(BioPEPAListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void dispose() {
        for (Map.Entry<QualifiedName, String> me : this.metaData.entrySet()) {
            try {
                this.resource.setPersistentProperty(me.getKey(), me.getValue());
            }
            catch (CoreException coreException) {}
        }
        try {
            for (IMarker marker : this.markers) {
                marker.delete();
            }
        }
        catch (CoreException coreException) {}
    }

    public String[] getComponentNames() {
        if (this.sbaModel != null) {
            return this.sbaModel.getComponentNames();
        }
        return null;
    }

    public String[] getDynamicVariableNames() {
        if (this.sbaModel != null) {
            return this.sbaModel.getDynamicVariableNames();
        }
        return null;
    }

    public String getProperty(String name) {
        QualifiedName key = new QualifiedName("uk.ac.ed.inf.biopepa.ui", name);
        if (this.metaData.containsKey(key)) {
            return this.metaData.get(key);
        }
        String s = null;
        try {
            s = this.resource.getPersistentProperty(key);
            this.metaData.put(key, s);
        }
        catch (CoreException coreException) {
            s = null;
        }
        return s;
    }

    public IResource getUnderlyingResource() {
        return this.resource;
    }

    public void parse() throws CoreException {
        Status status;
        long start = System.currentTimeMillis();
        String source = null;
        for (IMarker marker : this.markers) {
            marker.delete();
        }
        this.markers.clear();
        try {
            int c;
            BufferedReader in = new BufferedReader(new InputStreamReader(((IFile)this.resource).getContents()));
            StringBuffer buf = new StringBuffer();
            char[] cbuf = new char[4096];
            while ((c = in.read(cbuf)) != -1) {
                buf.append(cbuf, 0, c);
            }
            source = buf.toString();
        }
        catch (IOException e) {
            status = new Status(4, "uk.ac.ed.inf.biopepa.ui", "Input/Output problem", (Throwable)e);
            BioPEPAPlugin.getDefault().log((IStatus)status);
            Display.getDefault().asyncExec(this.bringProblemsToView);
            throw new CoreException((IStatus)status);
        }
        if (source != null) {
            try {
                this.astModel = BioPEPA.parse((String)source);
            }
            catch (Throwable e) {
                status = new Status(4, "uk.ac.ed.inf.biopepa.ui", "Parsing problem", e);
                if (e instanceof ParserException) {
                    ParserException pe = (ParserException)e;
                    IMarker marker = this.resource.createMarker("org.eclipse.core.resources.problemmarker");
                    marker.setAttribute("message", (Object)pe.getMessage());
                    marker.setAttribute("lineNumber", pe.getLine());
                    marker.setAttribute("charStart", pe.getChar());
                    marker.setAttribute("charEnd", pe.getChar() + pe.getLength());
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("transient", true);
                    this.markers.add(marker);
                } else {
                    BioPEPAPlugin.getDefault().log((IStatus)status);
                }
                Display.getDefault().asyncExec(this.bringProblemsToView);
                throw new CoreException((IStatus)status);
            }
        }
        this.compiledModel = BioPEPA.compile((Model)this.astModel);
        this.problems = this.compiledModel.compile();
        int c = 0;
        ProblemInfo[] problemInfoArray = this.problems;
        int n = this.problems.length;
        int pe = 0;
        while (pe < n) {
            ProblemInfo p = problemInfoArray[pe];
            if (p.severity.equals((Object)ProblemInfo.Severity.ERROR)) {
                ++c;
            }
            ++pe;
        }
        if (c == 0) {
            this.sbaModel = BioPEPA.generateSBA((ModelCompiler)this.compiledModel);
        } else {
            Display.getDefault().asyncExec(this.bringProblemsToView);
            this.sbaModel = null;
        }
        ProblemInfo[] problemInfoArray2 = this.problems;
        int n2 = this.problems.length;
        n = 0;
        while (n < n2) {
            ProblemInfo pi = problemInfoArray2[n];
            IMarker marker = this.resource.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("message", (Object)pi.message);
            marker.setAttribute("severity", BioPEPAModelImpl.eclipseSeverity(pi.severity));
            marker.setAttribute("transient", true);
            if (pi.sourceRange != null) {
                marker.setAttribute("lineNumber", pi.sourceRange.getLine());
                marker.setAttribute("charStart", pi.sourceRange.getChar());
                marker.setAttribute("charEnd", pi.sourceRange.getChar() + pi.sourceRange.getLength());
            }
            this.markers.add(marker);
            ++n;
        }
        this.notify(new BioPEPAEvent(this, BioPEPAEvent.Event.PARSED, System.currentTimeMillis() - start));
    }

    public void notify(BioPEPAEvent event) {
        for (BioPEPAListener l : this.listeners) {
            l.modelChanged(event);
        }
    }

    private static final int eclipseSeverity(ProblemInfo.Severity severity) {
        switch (severity) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void removeListener(BioPEPAListener listener) {
        this.listeners.remove(listener);
    }

    public void setProperty(String name, String value) {
        QualifiedName key = new QualifiedName("uk.ac.ed.inf.biopepa.ui", name);
        this.metaData.put(key, value);
    }

    public Result timeSeriesAnalysis(Solver solver, Parameters parameters, ExperimentSet.ExperimentLine experimentLine, IProgressMonitor monitor) throws CoreException {
        if (solver == null || parameters == null) {
            throw new NullPointerException();
        }
        try {
            ProgressMonitorImpl progressMonitor = monitor == null ? null : new ProgressMonitorImpl("", monitor);
            return solver.startTimeSeriesAnalysis(this.sbaModel, parameters, experimentLine, (ProgressMonitor)progressMonitor);
        }
        catch (BioPEPAException e) {
            Status status = new Status(4, "uk.ac.ed.inf.biopepa.ui", e.getMessage());
            throw new CoreException((IStatus)status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean errorsPresent() {
        try {
            IMarker marker;
            Iterator<IMarker> iterator = this.markers.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((Integer)(marker = iterator.next()).getAttribute("severity") != 2);
            return true;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    public SBAModel getSBAModel() {
        return this.sbaModel;
    }

    public ModelCompiler getCompiledModel() {
        return this.compiledModel;
    }

    private class ProgressMonitorImpl
    implements ProgressMonitor {
        IProgressMonitor eclipseMonitor;
        String name;

        ProgressMonitorImpl(String name, IProgressMonitor monitor) {
            this.eclipseMonitor = monitor;
            this.name = name;
        }

        public void beginTask(int amount) {
            this.eclipseMonitor.beginTask(this.name, amount == -1 ? -1 : amount);
        }

        public void done() {
            this.eclipseMonitor.done();
        }

        public boolean isCanceled() {
            return this.eclipseMonitor.isCanceled();
        }

        public void setCanceled(boolean state) {
        }

        public void worked(int worked) {
            this.eclipseMonitor.worked(worked);
        }
    }
}

