/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.export;

import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import uk.ac.ed.inf.biopepa.core.analysis.IntegerMatrix;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.sba.LineStringBuilder;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.views.BioPEPAInvariantsView;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.ReactionKnockoutPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferInvariantsWizard
extends Wizard {
    BioPEPAModel model;
    private ExportPage exportPage;
    private ReactionKnockoutPage reactionKnockoutPage;

    public InferInvariantsWizard(BioPEPAModel model) {
        if (model == null) {
            throw new NullPointerException("Error; model does not exist.");
        }
        this.model = model;
        this.setHelpAvailable(false);
        this.setWindowTitle("Infer invariants for Bio-PEPA");
    }

    public void addPages() {
        this.exportPage = new ExportPage("Infer invariants with the model");
        this.addPage((IWizardPage)this.exportPage);
        LineStringBuilder sb = new LineStringBuilder();
        sb.appendLine("De-select each reaction you wish to be ignored");
        sb.appendLine("for the purposes of invariate inference");
        this.reactionKnockoutPage = new ReactionKnockoutPage(this.model);
        this.reactionKnockoutPage.setHeaderHelp(sb.toString());
        this.reactionKnockoutPage.setDefaultSelection(true);
        this.addPage((IWizardPage)this.reactionKnockoutPage);
    }

    public String intercalateStrings(LinkedList<String> strings, String separator) {
        StringBuilder sb = new StringBuilder();
        int termIndex = 0;
        while (termIndex < strings.size() - 1) {
            sb.append(String.valueOf(strings.get(termIndex)) + separator);
            ++termIndex;
        }
        sb.append(strings.getLast());
        return sb.toString();
    }

    public boolean performFinish() {
        InvariantInferer inferer = new InvariantInferer(this.model.getSBAModel(), this.reactionKnockoutPage.getSelectedReactions());
        InvariantJob ijob = new InvariantJob("Invariants Inference");
        ijob.setDoStateInvariants(this.exportPage.getStateInvariantSelection());
        ijob.setDoActivityInvariants(this.exportPage.getActivityInvariantSelection());
        ijob.setInvariantInferer(inferer);
        ijob.schedule();
        return true;
    }

    public IResource getUnderlyingResource() {
        return this.model.getUnderlyingResource();
    }

    private class ExportPage
    extends WizardPage {
        private Button stateInvariantsCheck;
        private Button activityInvariantsCheck;
        private ModifyListener modifyListener;
        private Listener checkBoxListener;

        protected ExportPage(String pageName) {
            super(pageName);
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    ExportPage.this.validate();
                }
            };
            this.checkBoxListener = new Listener(){

                public void handleEvent(Event event) {
                    ExportPage.this.validate();
                }
            };
            this.setTitle("Infer Invariants");
            this.setDescription("Infer the invariants for the model");
        }

        public void createControl(Composite parent) {
            int labelStyle = 16388;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.setControl((Control)composite);
            Label tmpLabel = new Label(composite, labelStyle);
            String labelText = "Inference of invariants, you should have\n the 'Invariants' view open; if not go to:\n Window -> Show View -> Other -> Analysis -> Invariants";
            tmpLabel.setText(labelText);
            tmpLabel.setLayoutData((Object)this.createDefaultGridData());
            this.stateInvariantsCheck = new Button(composite, 32);
            this.stateInvariantsCheck.setText("Infer State Invariants");
            this.stateInvariantsCheck.setSelection(true);
            this.stateInvariantsCheck.addListener(13, this.checkBoxListener);
            this.activityInvariantsCheck = new Button(composite, 32);
            this.activityInvariantsCheck.setText("Infer Activity Invariants");
            this.activityInvariantsCheck.setSelection(true);
            this.activityInvariantsCheck.addListener(13, this.checkBoxListener);
        }

        public boolean getStateInvariantSelection() {
            return this.stateInvariantsCheck.getSelection();
        }

        public boolean getActivityInvariantSelection() {
            return this.activityInvariantsCheck.getSelection();
        }

        private void validate() {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            if (!this.stateInvariantsCheck.getSelection() && !this.activityInvariantsCheck.getSelection()) {
                this.setErrorMessage("Must infer at least one kind of invariant");
                this.setPageComplete(false);
            }
        }

        private GridData createDefaultGridData() {
            return new GridData(4, 0x1000000, true, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvariantInferer {
        private ComponentNode[] species;
        private SBAReaction[] reactions;
        private IntegerMatrix modelMatrix;
        private IntegerMatrix stateInvariantSolution = null;
        private IntegerMatrix activityInvariantSolution = null;

        InvariantInferer(SBAModel sbaModel, LinkedList<SBAReaction> reactions) {
            this.species = sbaModel.getComponents();
            this.reactions = reactions.toArray(new SBAReaction[0]);
        }

        public void computeModelMatrix() {
            int rows = this.species.length;
            int columns = this.reactions.length;
            IntegerMatrix imatrix = new IntegerMatrix(rows, columns);
            int rowNumber = 0;
            while (rowNumber < rows) {
                ComponentNode comp = this.species[rowNumber];
                String compName = comp.getName();
                int colNumber = 0;
                while (colNumber < columns) {
                    SBAReaction reaction = this.reactions[colNumber];
                    int effectOnComp = 0;
                    for (SBAComponentBehaviour cb : reaction.getReactants()) {
                        if (!cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT) || !cb.getName().equals(compName)) continue;
                        effectOnComp -= cb.getStoichiometry();
                    }
                    for (SBAComponentBehaviour cb : reaction.getProducts()) {
                        if (!cb.getName().equals(compName)) continue;
                        effectOnComp += cb.getStoichiometry();
                    }
                    imatrix.set(rowNumber, colNumber, effectOnComp);
                    ++colNumber;
                }
                ++rowNumber;
            }
            this.modelMatrix = imatrix;
        }

        public IntegerMatrix getModelMatrix() {
            return this.modelMatrix;
        }

        private void computeStateInvariantSolution() {
            IntegerMatrix solvedMatrix;
            if (this.modelMatrix == null) {
                throw new IllegalStateException();
            }
            this.stateInvariantSolution = solvedMatrix = this.modelMatrix.solveFourierMotzkin();
        }

        public IntegerMatrix getStateInvariantSolution() {
            if (this.stateInvariantSolution == null) {
                this.computeStateInvariantSolution();
            }
            return this.stateInvariantSolution;
        }

        public String printStateInvariantSolution() {
            LineStringBuilder lsb = new LineStringBuilder();
            for (String line : this.getStateInvariantStrings()) {
                lsb.appendLine(line);
            }
            return lsb.toString();
        }

        public LinkedList<String> getStateInvariantStrings() {
            LinkedList<String> resultStrings = new LinkedList<String>();
            IntegerMatrix invariantMatrix = this.getStateInvariantSolution();
            int rowIndex = 0;
            while (rowIndex < invariantMatrix.getRowDimension()) {
                StringBuilder sb = new StringBuilder();
                LinkedList<String> terms = new LinkedList<String>();
                int colIndex = 0;
                while (colIndex < invariantMatrix.getColumnDimension()) {
                    int value = invariantMatrix.get(rowIndex, colIndex);
                    ComponentNode comp = this.species[colIndex];
                    String compName = comp.getName();
                    switch (value) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            terms.add(compName);
                            break;
                        }
                        case -1: {
                            terms.add("-" + compName);
                            break;
                        }
                        default: {
                            terms.add("(" + value + " * " + compName + ")");
                        }
                    }
                    ++colIndex;
                }
                switch (terms.size()) {
                    case 0: {
                        sb.append("no terms");
                        break;
                    }
                    case 1: {
                        sb.append((String)terms.getFirst());
                        break;
                    }
                    default: {
                        sb.append(InferInvariantsWizard.this.intercalateStrings(terms, " + "));
                    }
                }
                sb.append(" is an invariant in this model");
                resultStrings.addLast(sb.toString());
                ++rowIndex;
            }
            return resultStrings;
        }

        public LinkedList<String> getUncoveredStateStrings() {
            LinkedList<String> resultStrings = new LinkedList<String>();
            IntegerMatrix invariantMatrix = this.getStateInvariantSolution();
            int colIndex = 0;
            while (colIndex < invariantMatrix.getColumnDimension()) {
                boolean seen = false;
                int rowIndex = 0;
                while (rowIndex < invariantMatrix.getRowDimension()) {
                    if (invariantMatrix.get(rowIndex, colIndex) != 0) {
                        seen = true;
                        break;
                    }
                    ++rowIndex;
                }
                if (!seen) {
                    resultStrings.add(this.species[colIndex].getName());
                }
                ++colIndex;
            }
            return resultStrings;
        }

        private void computeActivityInvariantSolution() {
            IntegerMatrix solvedMatrix;
            if (this.modelMatrix == null) {
                throw new IllegalStateException();
            }
            this.activityInvariantSolution = solvedMatrix = this.modelMatrix.transpose().solveFourierMotzkin();
        }

        public IntegerMatrix getActivityInvariantSolution() {
            if (this.activityInvariantSolution == null) {
                this.computeActivityInvariantSolution();
            }
            return this.activityInvariantSolution;
        }

        public String printActivityInvariantSolution() {
            LineStringBuilder lsb = new LineStringBuilder();
            for (String line : this.getActivityInvariantStrings()) {
                lsb.appendLine(line);
            }
            return lsb.toString();
        }

        public LinkedList<String> getActivityInvariantStrings() {
            LinkedList<String> resultStrings = new LinkedList<String>();
            IntegerMatrix invariantMatrix = this.getActivityInvariantSolution();
            int rowIndex = 0;
            while (rowIndex < invariantMatrix.getRowDimension()) {
                StringBuilder sb = new StringBuilder();
                LinkedList<String> terms = new LinkedList<String>();
                int colIndex = 0;
                while (colIndex < invariantMatrix.getColumnDimension()) {
                    int value = invariantMatrix.get(rowIndex, colIndex);
                    SBAReaction reaction = this.reactions[colIndex];
                    String reactName = reaction.getName();
                    switch (value) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            terms.add(reactName);
                            break;
                        }
                        case -1: {
                            terms.add("-" + reactName);
                            break;
                        }
                        default: {
                            terms.add("(" + value + " * " + reactName + ")");
                        }
                    }
                    ++colIndex;
                }
                switch (terms.size()) {
                    case 0: {
                        sb.append("no terms");
                        break;
                    }
                    case 1: {
                        sb.append("The reaction: " + (String)terms.getFirst() + " has no effect on the model");
                        break;
                    }
                    default: {
                        sb.append("Performing the following reactions returns the model to the same state: ");
                        sb.append(InferInvariantsWizard.this.intercalateStrings(terms, " + "));
                    }
                }
                resultStrings.addLast(sb.toString());
                ++rowIndex;
            }
            return resultStrings;
        }

        public LinkedList<String> getUncoveredActivityStrings() {
            LinkedList<String> resultStrings = new LinkedList<String>();
            IntegerMatrix invariantMatrix = this.getActivityInvariantSolution();
            int colIndex = 0;
            while (colIndex < invariantMatrix.getColumnDimension()) {
                boolean seen = false;
                int rowIndex = 0;
                while (rowIndex < invariantMatrix.getRowDimension()) {
                    if (invariantMatrix.get(rowIndex, colIndex) != 0) {
                        seen = true;
                        break;
                    }
                    ++rowIndex;
                }
                if (!seen) {
                    resultStrings.add(this.reactions[colIndex].getName());
                }
                ++colIndex;
            }
            return resultStrings;
        }
    }

    private class InvariantJob
    extends Job {
        private InvariantInferer inferer;
        private boolean doStateInvariants;
        private boolean doActivityInvariants;

        public InvariantJob(String name) {
            super(name);
            this.doStateInvariants = true;
            this.doActivityInvariants = true;
        }

        public void setInvariantInferer(InvariantInferer inferer) {
            this.inferer = inferer;
        }

        public void setDoStateInvariants(boolean b) {
            this.doStateInvariants = b;
        }

        public void setDoActivityInvariants(boolean b) {
            this.doActivityInvariants = b;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.inferer.computeModelMatrix();
            final LinkedList<String> stateInvariantStrings = this.doStateInvariants ? this.inferer.getStateInvariantStrings() : null;
            final LinkedList<String> uncoveredComponentStrings = this.doStateInvariants ? this.inferer.getUncoveredStateStrings() : null;
            final LinkedList<String> activityInvariantStrings = this.doActivityInvariants ? this.inferer.getActivityInvariantStrings() : null;
            final LinkedList<String> uncoveredActivityStrings = this.doActivityInvariants ? this.inferer.getUncoveredActivityStrings() : null;
            Runnable runnable = new Runnable(){

                public void run() {
                    String uncovered;
                    BioPEPAInvariantsView invview = BioPEPAInvariantsView.getDefault();
                    invview.clearInvariants();
                    if (InvariantJob.this.doStateInvariants) {
                        for (String invariant : stateInvariantStrings) {
                            invview.addInvariant(invariant);
                        }
                        if (stateInvariantStrings.isEmpty()) {
                            invview.addInvariant("No state invariants in this model");
                        } else if (!uncoveredComponentStrings.isEmpty()) {
                            uncovered = "The following components are not covered by any invariant: " + InferInvariantsWizard.this.intercalateStrings(uncoveredComponentStrings, ", ");
                            invview.addInvariant(uncovered);
                        }
                    }
                    if (InvariantJob.this.doActivityInvariants) {
                        for (String invariant : activityInvariantStrings) {
                            invview.addInvariant(invariant);
                        }
                        if (activityInvariantStrings.isEmpty()) {
                            invview.addInvariant("No activity invariants in this model");
                        } else if (!uncoveredActivityStrings.isEmpty()) {
                            uncovered = "The following reactions are not part of a loop: " + InferInvariantsWizard.this.intercalateStrings(uncoveredActivityStrings, ", ");
                            invview.addInvariant(uncovered);
                        }
                    }
                    String viewId = invview.getViewSite().getId();
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)invview);
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            };
            Display.getDefault().syncExec(runnable);
            return Status.OK_STATUS;
        }
    }
}

