/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.LineStringBuilder;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.interfaces.IResourceProvider;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.InitPopsExperimentPage;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.RateVariablesExperimentPage;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.ReactionKnockoutPage;

public class CreateExperimentationWizard
extends Wizard
implements IResourceProvider {
    BioPEPAModel model;
    private ExperimentSet experimentSet;
    private ReactionKnockoutPage reactionKnockoutPage;
    private InitPopsExperimentPage initPopsExperPage;
    private RateVariablesExperimentPage rateVarExperPage;

    public CreateExperimentationWizard(BioPEPAModel model) {
        if (model == null) {
            throw new NullPointerException("Error; model does not exist.");
        }
        this.model = model;
        this.setHelpAvailable(false);
        this.setWindowTitle("Create Experimentation .csv");
    }

    public ExperimentSet getExperimentSet() {
        return this.experimentSet;
    }

    public void addPages() {
        LineStringBuilder sb = new LineStringBuilder();
        sb.appendLine("For each reaction which is selected a single experiment of two ");
        sb.appendLine("lines will be performed. The first line in which the reaction is ");
        sb.appendLine("enabled and the second line in which the reaction is disabled. ");
        sb.appendLine("If you wish to range over only rate variables or initial component ");
        sb.appendLine("populations then just leave this page blank.");
        this.reactionKnockoutPage = new ReactionKnockoutPage(this.model);
        this.reactionKnockoutPage.setHeaderHelp(sb.toString());
        this.reactionKnockoutPage.setDefaultSelection(false);
        this.addPage((IWizardPage)this.reactionKnockoutPage);
        this.initPopsExperPage = new InitPopsExperimentPage(this.model);
        this.addPage((IWizardPage)this.initPopsExperPage);
        this.rateVarExperPage = new RateVariablesExperimentPage(this.model);
        this.addPage((IWizardPage)this.rateVarExperPage);
    }

    public boolean performFinish() {
        ExperimentSet experimentation = new ExperimentSet();
        this.initPopsExperPage.addExperimentArrays(experimentation);
        LinkedList<SBAReaction> selectedReactions = this.reactionKnockoutPage.getSelectedReactions();
        for (SBAReaction reaction : selectedReactions) {
            String reactionName = reaction.getName();
            String lineName = String.valueOf(reactionName) + "-off";
            ExperimentSet experimentSet = experimentation;
            experimentSet.getClass();
            ExperimentSet.ExperimentLine experLineOff = new ExperimentSet.ExperimentLine(experimentSet, lineName);
            experLineOff.addReactionActivation(reactionName, false);
            experimentation.addExperimentLine(experLineOff);
            lineName = String.valueOf(reactionName) + "-on";
            ExperimentSet experimentSet2 = experimentation;
            experimentSet2.getClass();
            ExperimentSet.ExperimentLine experLineOn = new ExperimentSet.ExperimentLine(experimentSet2, lineName);
            experLineOn.addReactionActivation(reactionName, true);
            experimentation.addExperimentLine(experLineOn);
        }
        this.rateVarExperPage.addExperimentArrays(experimentation);
        this.experimentSet = experimentation;
        return true;
    }

    public IResource getUnderlyingResource() {
        return null;
    }
}

