/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.VariableData;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.LineStringBuilder;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.AbstractExperimentPage;

public class RateVariablesExperimentPage
extends AbstractExperimentPage {
    public static final String wizardPageName = "Rate Variables Setup Page";
    private BioPEPAModel model;

    public RateVariablesExperimentPage(BioPEPAModel model) {
        super(wizardPageName);
        this.model = model;
        this.setTitle("Rate Variables Setup and Experimentation Page");
        this.setDescription("Set up experiments over rate variables ");
        LineStringBuilder sb = new LineStringBuilder();
        sb.append("For each variable that you wish to range over ");
        sb.appendLine("either check the left box");
        sb.append("and enter a comma ");
        sb.appendLine("separated list of double values or check the right ");
        sb.append("box and enter a range via start and stop values with ");
        sb.appendLine("a step size.");
        sb.appendLine("Any rate variable with unchecked boxes will not be ranged ");
        sb.appendLine("over in this experiment and their default values used.");
        super.setHeader(sb.toString());
        ModelCompiler mCompiler = model.getCompiledModel();
        VariableData[] dynVariableData = mCompiler.getStaticVariables();
        this.experimentObjectNameHints = new AbstractExperimentPage.NameHintPair[dynVariableData.length];
        int i = 0;
        VariableData[] variableDataArray = dynVariableData;
        int n = dynVariableData.length;
        int n2 = 0;
        while (n2 < n) {
            VariableData dynVariable = variableDataArray[n2];
            String name = dynVariable.getName();
            CompiledExpression value = dynVariable.getValue();
            String hint = value.toString();
            if (hint.length() > 30) {
                hint = "expr";
            }
            this.experimentObjectNameHints[i++] = new AbstractExperimentPage.NameHintPair(name, hint);
            ++n2;
        }
    }

    public void addExperimentArrays(ExperimentSet experiment) {
        for (AbstractExperimentPage.ArrayInput arrayInput : this.arrayInputs) {
            Number[] values;
            String varName = arrayInput.getName();
            Number[] numberArray = values = arrayInput.getDoubleValues();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Number value = numberArray[n2];
                ExperimentSet experimentSet = experiment;
                experimentSet.getClass();
                ExperimentSet.ExperimentLine eline = new ExperimentSet.ExperimentLine(experimentSet, String.valueOf(varName) + "-" + value);
                eline.addRateValue(varName, value);
                experiment.addExperimentLine(eline);
                ++n2;
            }
        }
    }
}

