/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotview.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.dialogs.ChartPreview;
import uk.ac.ed.inf.common.ui.plotview.views.DetachAction;
import uk.ac.ed.inf.common.ui.plotview.views.RenameTabAction;
import uk.ac.ed.inf.common.ui.plotview.views.SaveToCSVAction;
import uk.ac.ed.inf.common.ui.plotview.views.SaveToPNGAction;
import uk.ac.ed.inf.common.ui.plotview.views.actions.CloseTabAction;
import uk.ac.ed.inf.common.ui.plotview.views.actions.PlotViewAction;

public class PlotView
extends ViewPart
implements ISelectionProvider {
    public static final String ID = "uk.ac.ed.inf.common.ui.plotview.views.PlotView";
    private TabFolder folder;
    private PlotViewAction renameTabAction;
    private PlotViewAction closeTabAction;
    private PlotViewAction saveToPNGAction;
    private PlotViewAction detachAction;
    private PlotViewAction saveToCSVAction;
    private HashMap<TabItem, IChart> charts = new HashMap();
    private IWorkbenchPage page;
    private int figureCounter = 1;
    private ArrayList<ISelectionChangedListener> listeners = new ArrayList();

    public synchronized void reveal(IChart chart) {
        this.reveal(chart, "Figure " + this.figureCounter++);
    }

    public synchronized void reveal(IChart chart, String name) {
        if (name == null || chart == null) {
            throw new NullPointerException();
        }
        TabItem item = new TabItem(this.folder, 0);
        item.setText(name);
        Composite composite = new Composite((Composite)this.folder, 0);
        composite.setLayout((Layout)new FillLayout());
        Canvas paintCanvas = new Canvas(composite, 2048);
        paintCanvas.setBackground(Display.getDefault().getSystemColor(1));
        ChartPreview preview = new ChartPreview(chart);
        paintCanvas.addPaintListener((PaintListener)preview);
        paintCanvas.addControlListener((ControlListener)preview);
        preview.setPreview(paintCanvas);
        preview.renderModel();
        item.setControl((Control)composite);
        this.charts.put(item, chart);
        this.folder.setSelection(item);
        this.notify((IStructuredSelection)new StructuredSelection((Object)chart));
    }

    public synchronized void close(IChart chart) {
        TabItem itemToDispose = this.getTab(chart);
        if (itemToDispose != null) {
            this.charts.remove(itemToDispose);
            if (!itemToDispose.isDisposed()) {
                itemToDispose.dispose();
            }
        }
        this.notify((IStructuredSelection)this.getSelection());
    }

    synchronized TabItem getTab(IChart chart) {
        TabItem foundItem = null;
        for (Map.Entry<TabItem, IChart> entry : this.charts.entrySet()) {
            if (entry.getValue() != chart) continue;
            foundItem = entry.getKey();
            break;
        }
        return foundItem;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.page = this.getSite().getPage();
    }

    IWorkbenchPage getPage() {
        return this.page;
    }

    public void createPartControl(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlotView.this.notify((IStructuredSelection)PlotView.this.getSelection());
            }
        };
        this.folder = new TabFolder(parent, 0);
        this.folder.addSelectionListener((SelectionListener)listener);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PlotView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.folder);
        this.folder.setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.renameTabAction);
        manager.add((IAction)this.closeTabAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.renameTabAction);
        manager.add((IAction)this.detachAction);
        manager.add((IAction)this.closeTabAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.saveToPNGAction);
        manager.add((IAction)this.saveToCSVAction);
    }

    private void makeActions() {
        this.renameTabAction = new RenameTabAction(this);
        this.saveToPNGAction = new SaveToPNGAction(this);
        this.closeTabAction = new CloseTabAction(this);
        this.detachAction = new DetachAction(this);
        this.saveToCSVAction = new SaveToCSVAction(this);
    }

    public void setFocus() {
        this.folder.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null || !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        int selectionIndex = this.folder.getSelectionIndex();
        if (selectionIndex == -1) {
            return StructuredSelection.EMPTY;
        }
        IChart chart = this.charts.get(this.folder.getItem(selectionIndex));
        if (chart == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)chart);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object chart = structuredSelection.getFirstElement();
        if (!(chart instanceof IChart)) {
            return;
        }
        IChart newSelection = (IChart)chart;
        TabItem item = this.getTab(newSelection);
        if (item != null) {
            this.folder.setSelection(item);
            this.notify(structuredSelection);
        }
    }

    private void notify(IStructuredSelection selection) {
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection));
        }
    }
}

