/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotview.views;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotview.PlotViewPlugin;
import uk.ac.ed.inf.common.ui.plotview.views.PlotView;
import uk.ac.ed.inf.common.ui.plotview.views.actions.PlotViewAction;

public class SaveToCSVAction
extends PlotViewAction {
    private static final String EXTENSION = "csv";

    public SaveToCSVAction(PlotView view) {
        super(view);
        this.setText("Export to CSV");
        this.setToolTipText("Export chart to CSV file");
    }

    protected void doRun(IStructuredSelection selection) {
        IChart chart = (IChart)selection.getFirstElement();
        TabItem selectedItem = this.view.getTab(chart);
        Shell shell = selectedItem.getControl().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalName(selectedItem.getText() != null ? String.valueOf(selectedItem.getText()) + "." + EXTENSION : "");
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        IFile file = this.getFile(shell, path);
        final ContainerGenerator generator = new ContainerGenerator(file.getParent().getFullPath());
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    generator.generateContainer(monitor);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)shell, (String)"Error saving", (String)"An error has occurred while exporting the graph.", (IStatus)PlotViewPlugin.wrapException(e.getMessage(), (Exception)((Object)e)));
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(Plotting.getPlottingTools().convertToCSV(chart));
            if (file.exists()) {
                file.setContents((InputStream)is, true, false, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.create((InputStream)is, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)shell, (String)"Error converting", (String)"An error has occurred while converting the resource", (IStatus)PlotViewPlugin.wrapException("Error converting chart", e));
        }
    }

    private IFile getFile(Shell shell, IPath path) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        String extension = file.getFileExtension();
        if ((extension == null || !extension.equalsIgnoreCase(EXTENSION)) && MessageDialog.openQuestion((Shell)shell, (String)"Extension Required", (String)"The file specified does not have the 'csv' extension. Would you like to add the extension?")) {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(file.getFullPath().addFileExtension(EXTENSION));
        }
        return file;
    }
}

