/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import uk.ac.ed.inf.common.ui.wizards.IActionFieldsProvider;
import uk.ac.ed.inf.common.ui.wizards.internal.FileLocationPage;
import uk.ac.ed.inf.common.ui.wizards.internal.IUpdatable;
import uk.ac.ed.inf.common.ui.wizards.internal.PassageTimePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PassageTimeAnalysisWizard
extends Wizard {
    private static final String FILE_LOCATION_PAGE = "file_location_page";
    private static final String PASSAGE_TIME_PAGE = "passage_time_page";
    private Map<String, String> fOptionMap = new HashMap<String, String>();
    private IFile fInputFile;
    private IActionFieldsProvider fProvider;

    protected PassageTimeAnalysisWizard(IFile inputFile, IActionFieldsProvider provider) {
        if (inputFile == null) {
            throw new NullPointerException();
        }
        if (provider == null) {
            provider = IActionFieldsProvider.DO_NOTHING_PROVIDER;
        }
        this.fInputFile = inputFile;
        this.fProvider = provider;
    }

    protected PassageTimeAnalysisWizard(IFile inputFile) {
        this(inputFile, null);
    }

    public final void addPages() {
        this.addPage((IWizardPage)new FileLocationPage(FILE_LOCATION_PAGE));
        this.addPage((IWizardPage)new PassageTimePage(PASSAGE_TIME_PAGE, this.fProvider));
    }

    public IFile getInputFile() {
        return this.fInputFile;
    }

    public Map<String, String> getOptionMap() {
        return this.fOptionMap;
    }

    public final boolean performFinish() {
        this.fOptionMap.put("uk.ac.ed.inf.common.file_path", this.fInputFile.getLocation().toString());
        IUpdatable updatable = (IUpdatable)this.getPage(FILE_LOCATION_PAGE);
        updatable.update();
        updatable = (IUpdatable)this.getPage(PASSAGE_TIME_PAGE);
        updatable.update();
        return this.doPerformFinish(this.fOptionMap);
    }

    protected abstract boolean doPerformFinish(Map<String, String> var1);
}

