/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsMap {
    private HashMap<Parameter, Object> options = new HashMap();

    public OptionsMap() {
        this.options.put(Parameter.Solver, Parameter.Solver.defaultValue);
        this.options.put(Parameter.PreConditioner, Parameter.PreConditioner.defaultValue);
        this.options.put(Parameter.Start_Time, Parameter.Start_Time.defaultValue);
        this.options.put(Parameter.Stop_Time, Parameter.Stop_Time.defaultValue);
        this.options.put(Parameter.Step_Size, Parameter.Step_Size.defaultValue);
        this.options.put(Parameter.Independent_Replications, Parameter.Independent_Replications.defaultValue);
        this.options.put(Parameter.Relative_Error, Parameter.Relative_Error.defaultValue);
        this.options.put(Parameter.Absolute_Error, Parameter.Absolute_Error.defaultValue);
        this.options.put(Parameter.Data_Points, Parameter.Data_Points.defaultValue);
        this.options.put(Parameter.Components, Parameter.Components.defaultValue);
        this.options.put(Parameter.Confidence_Interval, Parameter.Confidence_Interval.defaultValue);
    }

    public Object getValue(Parameter parameter) {
        return this.options.get((Object)parameter);
    }

    public String serialise(Parameter parameter) {
        if (parameter.equals((Object)Parameter.Components)) {
            String[] sa = (String[])this.options.get((Object)parameter);
            StringBuilder sb = new StringBuilder();
            String[] stringArray = sa;
            int n = sa.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append(s.length()).append(":").append(s);
                ++n2;
            }
            return sb.toString();
        }
        return this.options.get((Object)parameter).toString();
    }

    public void setValue(Parameter parameter, Object value) {
        if (parameter.parameterClass.isInstance(value)) {
            this.options.put(parameter, value);
        } else {
            if ((parameter.equals((Object)Parameter.Solver) || parameter.equals((Object)Parameter.PreConditioner)) && value instanceof String) {
                String s = (String)value;
                Enum[] o = parameter.equals((Object)Parameter.Solver) ? Solver.values() : PreConditioner.values();
                Enum[] enumArray = o;
                int n = o.length;
                int n2 = 0;
                while (n2 < n) {
                    Enum oo = enumArray[n2];
                    if (oo.toString().equals(s)) {
                        this.options.put(parameter, oo);
                        return;
                    }
                    ++n2;
                }
                throw new IllegalArgumentException("Value is not of type " + parameter.parameterClass.getName() + " and cannot be constructed using a String as a parameter.");
            }
            if (parameter.equals((Object)Parameter.Components) && value instanceof String) {
                StringBuilder sb = new StringBuilder((String)value);
                ArrayList<String> al = new ArrayList<String>();
                try {
                    while (sb.length() > 0) {
                        int index = sb.indexOf(":");
                        int length = Integer.parseInt(sb.substring(0, index));
                        sb.delete(0, index + 1);
                        al.add(sb.substring(0, length));
                        sb.delete(0, length);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(String.valueOf(parameter.descriptiveName) + " requires a legal bencoded string.");
                }
                this.options.put(parameter, al.toArray(new String[0]));
            } else if (value instanceof String) {
                try {
                    Constructor<?> constructor = parameter.parameterClass.getConstructor(String.class);
                    Object o = constructor.newInstance(value);
                    this.options.put(parameter, o);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Value is not of type " + parameter.parameterClass.getName() + " and cannot be constructed using a String as a parameter.");
                }
            } else {
                throw new IllegalArgumentException("Value is not of type " + parameter.parameterClass.getName());
            }
        }
    }

    public Set<Parameter> keySet() {
        return this.options.keySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameter {
        Solver("Solver", "solver", Solver.class, (Object)((Object)uk.ac.ed.inf.pepa.OptionsMap$Solver.Direct)),
        PreConditioner("Preconditioner", "preconditioner", PreConditioner.class, (Object)((Object)uk.ac.ed.inf.pepa.OptionsMap$PreConditioner.None)),
        Start_Time("Start time", "start-time", Double.class, 0.0),
        Stop_Time("Stop time", "stop-time", Double.class, 100.0),
        Step_Size("Step size", "step-size", Double.class, 0.001),
        Data_Points("Number of data points", "data-points", Integer.class, 100),
        Components("Components", "components", new String[0].getClass(), new String[0]),
        Independent_Replications("Number of independent replications", "replications", Integer.class, 1),
        Relative_Error("Relative error", "relative-error", Double.class, 1.0E-4),
        Absolute_Error("Absolute error", "absolute-error", Double.class, 1.0E-4),
        Confidence_Interval("Confidence interval", "confidence-interval", Double.class, 0.05);

        Class<?> parameterClass;
        String argument;
        String descriptiveName;
        Object defaultValue;

        private Parameter(String name, String argument, Class<?> parameterClass, Object defaultValue) {
            this.descriptiveName = name;
            this.argument = argument;
            this.parameterClass = parameterClass;
            this.defaultValue = defaultValue;
        }

        public Object getDefault() {
            return this.defaultValue;
        }

        public String toString() {
            return this.descriptiveName;
        }

        public String getKey() {
            return "s9552712-" + this.argument;
        }

        public Class<? extends Object> getType() {
            return this.parameterClass;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PreConditioner {
        None,
        AMG,
        AMGnoSSOR,
        ICC,
        SSOR,
        Diagonal,
        ILU,
        ILUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Solver {
        Direct(SolverType.CTMC, "direct", "MTJ Direct solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[0];
            }
        }
        ,
        CG(SolverType.CTMC, "cg", "MTJ Conjungate Gradient solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[0];
            }
        }
        ,
        CGS(SolverType.CTMC, "cgs", "MTJ Conjungate Gradient Stablized solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[0];
            }
        }
        ,
        BiCG(SolverType.CTMC, "bicg", "MTJ BiConjungate Gradient solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[0];
            }
        }
        ,
        BiCGS(SolverType.CTMC, "bicgs", "BiConjungate Gradient Stablized solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[0];
            }
        }
        ,
        GMRES(SolverType.CTMC, "gmres", "MTJ GMRES solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[0];
            }
        }
        ,
        IR(SolverType.CTMC, "ir", "MTJ Iterative Refinement solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[0];
            }
        }
        ,
        QMR(SolverType.CTMC, "qmr", "MTJ Quasi-Minimal Residual solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[0];
            }
        }
        ,
        Gillespie(SolverType.Stochastic, "gillespie", "Gillespies Stochastic Algorithm"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[]{Parameter.Start_Time, Parameter.Stop_Time, Parameter.Components, Parameter.Data_Points, Parameter.Independent_Replications, Parameter.Confidence_Interval};
            }
        }
        ,
        Gibson_Bruck(SolverType.Stochastic, "gibson-bruck", "Gibson-Bruck Stochastic Algorithm"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[]{Parameter.Start_Time, Parameter.Stop_Time, Parameter.Components, Parameter.Data_Points, Parameter.Independent_Replications, Parameter.Confidence_Interval};
            }
        }
        ,
        DOPR(SolverType.ODE, "dopr-adaptive", "Adaptive step-size 5th-order Dormand Prince ODE Solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[]{Parameter.Start_Time, Parameter.Stop_Time, Parameter.Components, Parameter.Data_Points, Parameter.Step_Size, Parameter.Relative_Error, Parameter.Absolute_Error};
            }
        }
        ,
        IMEX(SolverType.ODE, "imex-stiff", "Implicit-Explicit Runge Kutta ODE Solver"){

            public Parameter[] getRequiredParameters() {
                return new Parameter[]{Parameter.Start_Time, Parameter.Stop_Time, Parameter.Components, Parameter.Data_Points, Parameter.Step_Size, Parameter.Relative_Error, Parameter.Absolute_Error};
            }
        };

        SolverType type;
        String argument;
        String name;

        private Solver(SolverType type, String argument, String name) {
            this.type = type;
            this.argument = argument;
            this.name = name;
        }

        public String getDescriptiveName() {
            return this.name;
        }

        public String getArgumentName() {
            return this.argument;
        }

        public SolverType getType() {
            return this.type;
        }

        public String toString() {
            return this.argument;
        }

        public abstract Parameter[] getRequiredParameters();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SolverType {
        CTMC,
        Stochastic,
        ODE;

    }
}

