/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.analysis;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import uk.ac.ed.inf.pepa.analysis.IAlphabetProvider;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.analysis.internal.ASTActionUsageVisitor;
import uk.ac.ed.inf.pepa.analysis.internal.AlphabetProvider;
import uk.ac.ed.inf.pepa.analysis.internal.ProblemManager;
import uk.ac.ed.inf.pepa.analysis.internal.ReferenceCounterVisitor;
import uk.ac.ed.inf.pepa.analysis.internal.UnguardedPathDetector;
import uk.ac.ed.inf.pepa.parsing.ActionSuperNode;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.MoveOnVisitor;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticAnalyser {
    private static Logger logger = Logger.getLogger(StaticAnalyser.class);
    private ModelNode model;
    private ProblemManager problemManager;
    private IAlphabetProvider alphabets;

    public StaticAnalyser(ModelNode model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
        this.analyse();
    }

    public IAlphabetProvider getAlphabetProvider() {
        return this.alphabets;
    }

    private void analyse() {
        IProblem[] iProblemArray = this.model.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                logger.debug((Object)"At least a severe error, aborting static analysis...");
                return;
            }
            ++n2;
        }
        this.problemManager = new ProblemManager(this.model);
        this.model.accept(new ReferenceCounterVisitor(this.problemManager));
        if (!this.problemManager.hasError()) {
            this.alphabets = new AlphabetProvider(this.model);
            this.unguardedProcesses();
            this.unusedActions();
            this.localDeadLockAnalysis();
            this.reachabilityAnalysis();
            this.choiceAnalysis();
            this.selfLoopAnalysis();
            this.implementCompositionLoop();
        }
        this.problemManager.setProblems();
    }

    private Set<String> unusedActions() {
        ActionTypeNode[] actions2;
        ASTActionUsageVisitor v = new ASTActionUsageVisitor(this.model);
        ActionTypeNode[] actionTypeNodeArray = actions2 = v.getListedButNeverDeclared();
        int n = actions2.length;
        int n2 = 0;
        while (n2 < n) {
            ActionTypeNode action = actionTypeNodeArray[n2];
            this.problemManager.redundantAction(action);
            ++n2;
        }
        return v.getSharedNamed();
    }

    private void unsharedActions(Set<String> sharedActions) {
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        for (Set set : this.alphabets.getActionAlphabets().values()) {
            for (String action : set) {
                if (sharedActions.contains(action)) continue;
                Integer value = (Integer)occurrences.get(action);
                if (value == null) {
                    occurrences.put(action, 1);
                    continue;
                }
                System.err.println("Complain..." + action);
            }
        }
    }

    private void implementCompositionLoop() {
        for (ProcessDefinitionNode def : this.model.processDefinitions()) {
            class DefineCooperation
            extends MoveOnVisitor {
                private boolean result = false;

                DefineCooperation() {
                }

                public void visitCooperationNode(CooperationNode cooperation) {
                    this.result = true;
                    super.visitCooperationNode(cooperation);
                }
            }
            DefineCooperation v = new DefineCooperation();
            logger.debug((Object)("Visiting " + def.getName().getName() + " ..."));
            def.getNode().accept(v);
            if (v.result) {
                logger.debug((Object)"...which is defining cooperation...");
                HashSet<String> reachedProcesses = this.alphabets.getProcessAlphabets().get(def.getName().getName());
                if (!reachedProcesses.contains(def.getName().getName())) continue;
                logger.debug((Object)"which has got problems!");
                this.problemManager.cooperationLoop(def.getName().getName());
                return;
            }
            logger.debug((Object)"...which is not definining cooperation.");
        }
    }

    private void unguardedProcesses() {
        ConstantProcessNode[] constants;
        UnguardedPathDetector detector = new UnguardedPathDetector(this.model);
        ConstantProcessNode[] constantProcessNodeArray = constants = detector.getConstantsAffected();
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            ConstantProcessNode c = constantProcessNodeArray[n2];
            this.problemManager.unguardedProcess(c.getName());
            ++n2;
        }
    }

    private void localDeadLockAnalysis() {
        this.model.accept(new LocalDeadlock());
    }

    public static void main(String[] args) throws IOException {
        ModelNode node = (ModelNode)PepaTools.parse(PepaTools.readText(args[0]));
        new StaticAnalyser(node);
        IProblem[] iProblemArray = node.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem p = iProblemArray[n2];
            System.out.println(p.getMessage());
            ++n2;
        }
    }

    private void selfLoopAnalysis() {
    }

    private void choiceAnalysis() {
    }

    private void reachabilityAnalysis() {
        final HashSet reachableConstants = new HashSet();
        this.model.getSystemEquation().accept(new MoveOnVisitor(){

            public void visitConstantProcessNode(ConstantProcessNode constant) {
                reachableConstants.add(constant.getName());
            }
        });
        while (true) {
            final HashSet roundConstants = new HashSet();
            for (String constant : reachableConstants) {
                for (ProcessDefinitionNode def : this.model.processDefinitions()) {
                    if (!constant.equals(def.getName().getName())) continue;
                    def.getNode().accept(new MoveOnVisitor(){

                        public void visitConstantProcessNode(ConstantProcessNode constant) {
                            roundConstants.add(constant.getName());
                        }
                    });
                }
            }
            boolean newAdded = reachableConstants.addAll(roundConstants);
            if (!newAdded) break;
            roundConstants.clear();
        }
        for (ProcessDefinitionNode def : this.model.processDefinitions()) {
            if (reachableConstants.contains(def.getName().getName())) continue;
            this.problemManager.unreachableProcessDefinition(def);
        }
    }

    class LocalDeadlock
    extends MoveOnVisitor {
        HashSet<String> collectedAction = new HashSet();

        LocalDeadlock() {
        }

        public void visitModelNode(ModelNode model) {
            for (ProcessDefinitionNode definition : model.processDefinitions()) {
                definition.getNode().accept(this);
            }
            model.getSystemEquation().accept(this);
        }

        public void visitConstantProcessNode(ConstantProcessNode constant) {
            this.collectedAction.addAll((Collection<String>)StaticAnalyser.this.alphabets.getActionAlphabets().get(constant.getName()));
        }

        public void visitPrefixNode(PrefixNode prefix) {
            ActionSuperNode action = prefix.getActivity().getAction();
            if (action instanceof ActionTypeNode) {
                this.collectedAction.add(((ActionTypeNode)action).getType());
            }
            prefix.getTarget().accept(this);
        }

        public void visitHidingNode(HidingNode hiding) {
            LocalDeadlock v = new LocalDeadlock();
            hiding.getProcess().accept(v);
            for (ActionTypeNode a : hiding.getActionSet()) {
                v.collectedAction.remove(a);
            }
        }

        public void visitCooperationNode(CooperationNode cooperation) {
            LocalDeadlock lhs = new LocalDeadlock();
            cooperation.getLeft().accept(lhs);
            LocalDeadlock rhs = new LocalDeadlock();
            cooperation.getRight().accept(rhs);
            this.collectedAction.addAll(lhs.collectedAction);
            this.collectedAction.addAll(rhs.collectedAction);
            for (ActionTypeNode cooperationAction : cooperation.getActionSet()) {
                boolean lhsContains = lhs.collectedAction.contains(cooperationAction.getType());
                boolean rhsContains = rhs.collectedAction.contains(cooperationAction.getType());
                if (lhsContains && !rhsContains || !lhsContains && rhsContains) {
                    StaticAnalyser.this.problemManager.potentialDeadLock(cooperationAction);
                }
                if (lhsContains || rhsContains) continue;
                StaticAnalyser.this.problemManager.redundantAction(cooperationAction);
            }
        }
    }
}

