/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.analysis.internal;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.inf.pepa.analysis.internal.UnguardedPathDetector;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.DefaultVisitor;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathVisitor
extends DefaultVisitor {
    List<ConstantProcessNode> path = new ArrayList<ConstantProcessNode>();
    UnguardedPathDetector detector;

    public PathVisitor(UnguardedPathDetector detector) {
        this.detector = detector;
    }

    public PathVisitor(UnguardedPathDetector detector, List<ConstantProcessNode> path) {
        this(detector);
        this.path.addAll(path);
    }

    @Override
    public void visitAggregationNode(AggregationNode aggregation) {
        aggregation.getProcessNode().accept(this);
    }

    @Override
    public void visitChoiceNode(ChoiceNode choice) {
        PathVisitor lPath = new PathVisitor(this.detector, this.path);
        PathVisitor rPath = new PathVisitor(this.detector, this.path);
        choice.getLeft().accept(lPath);
        choice.getRight().accept(rPath);
    }

    @Override
    public void visitConstantProcessNode(ConstantProcessNode constant) {
        for (ConstantProcessNode element : this.path) {
            if (!constant.getName().equals(element.getName())) continue;
            for (ConstantProcessNode n : this.path) {
                this.detector.constants.add(n);
            }
            return;
        }
        ASTNode procDef = this.detector.model.getResolver().getProcessDefinition(constant.getName());
        procDef.accept(this);
    }

    @Override
    public void visitCooperationNode(CooperationNode cooperation) {
    }

    @Override
    public void visitHidingNode(HidingNode hiding) {
        hiding.getProcess().accept(this);
    }

    @Override
    public void visitPrefixNode(PrefixNode prefix) {
    }

    @Override
    public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
        this.path.add(processDefinition.getName());
        processDefinition.getNode().accept(this);
    }
}

