/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.analysis.internal;

import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.parsing.ASTNode;

public class ProblemFactory {
    public static IProblem createProblem(final int id, final int startLine, final int startColumn, final int endLine, final int endColumn, final int initChar, final int length, final String message) {
        return new IProblem(){

            public int getId() {
                return id;
            }

            public int getChar() {
                return initChar;
            }

            public int getLength() {
                return length;
            }

            public int getStartLine() {
                return startLine;
            }

            public int getStartColumn() {
                return startColumn;
            }

            public int getEndLine() {
                return endLine;
            }

            public int getEndColumn() {
                return endColumn;
            }

            public String getMessage() {
                return message;
            }

            public boolean isError() {
                return (id & 0x100000) != 0;
            }

            public boolean isWarning() {
                return (id & 0x200000) != 0;
            }
        };
    }

    public static IProblem buildProblem(int id, ASTNode affectedNode, String message) {
        return ProblemFactory.createProblem(id, affectedNode.getLeftLocation().getLine(), affectedNode.getLeftLocation().getColumn(), affectedNode.getRightLocation().getLine(), affectedNode.getRightLocation().getColumn(), affectedNode.getLeftLocation().getChar(), affectedNode.getRightLocation().getChar() - affectedNode.getLeftLocation().getChar(), message);
    }

    public static void main(String[] args) {
        int startLine = 1;
        int startColumn = 1;
        int endLine = 1;
        int endColumn = 0;
        int initChar = 0;
        int length = 0;
        String message = null;
        int id = 1310727;
        System.out.println(ProblemFactory.createProblem(id, startLine, startColumn, endLine, endColumn, initChar, length, message).isError());
        id = 0x220006;
        System.out.println(ProblemFactory.createProblem(id, startLine, startColumn, endLine, endColumn, initChar, length, message).isError());
        id = 2162692;
        System.out.println(ProblemFactory.createProblem(id, startLine, startColumn, endLine, endColumn, initChar, length, message).isError());
        id = 0x110001;
        System.out.println(ProblemFactory.createProblem(id, startLine, startColumn, endLine, endColumn, initChar, length, message).isWarning());
    }
}

