/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.analysis.internal;

import java.util.LinkedList;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.analysis.internal.ProblemFactory;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;

public class ProblemManager {
    private ModelNode model;
    private Problems problems = new Problems();

    public ProblemManager(ModelNode model) {
        this.model = model;
    }

    public boolean hasError() {
        return this.problems.hasError();
    }

    public void transientStateProblem(String name) {
        String message = "Process " + name + " could be a transient local state";
        this.problems.add(ProblemFactory.buildProblem(0x220006, this.model.getResolver().getProcessDefinition(name), message));
    }

    public void processMultipleDeclaration(String name) {
        String message = "Process " + name + " declared multiple times";
        this.problems.add(ProblemFactory.buildProblem(1179660, this.model.getResolver().getProcessDefinition(name), message));
    }

    public void processNotDefinedError(String name) {
        ASTNode[] affectedNodes;
        String message = "Process " + name + " not defined";
        ASTNode[] aSTNodeArray = affectedNodes = this.model.getResolver().getConstantUsage(name);
        int n = affectedNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode node = aSTNodeArray[n2];
            this.problems.add(ProblemFactory.buildProblem(1179651, node, message));
            ++n2;
        }
    }

    public void rateNotDefinedProblem(String name) {
        String message = "Rate " + name + " not defined";
        ASTNode[] aSTNodeArray = this.model.getResolver().getRateUsage(name);
        int n = aSTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode node = aSTNodeArray[n2];
            this.problems.add(ProblemFactory.buildProblem(0x110001, node, message));
            ++n2;
        }
    }

    public void rateNotUsedProblem(String name) {
        String message = "Rate " + name + " not used";
        this.problems.add(ProblemFactory.buildProblem(2162692, this.model.getResolver().getRateDefinition(name), message));
    }

    public void rateMultipleDeclaration(String name) {
        String message = "Rate " + name + " declared multiple times";
        this.problems.add(ProblemFactory.buildProblem(0x110002, this.model.getResolver().getRateDefinition(name), message));
    }

    public void unreachableProcessDefinition(ProcessDefinitionNode definition) {
        String message = "Process definition: " + definition.getName().getName() + " never used";
        this.problems.add(ProblemFactory.buildProblem(0x220008, definition, message));
    }

    public void redundantAction(ActionTypeNode action) {
        String message = "Redundant action declared: " + action.getType();
        this.problems.add(ProblemFactory.buildProblem(2293770, action, message));
    }

    public void potentialDeadLock(ActionTypeNode action) {
        String message = "Potential local deadlock: " + action.getType();
        this.problems.add(ProblemFactory.buildProblem(2293769, action, message));
    }

    public void unguardedProcess(String name) {
        String message = "Process: " + name + " unguarded";
        this.problems.add(ProblemFactory.buildProblem(1179659, this.model.getResolver().getProcessDefinition(name), message));
    }

    public void cooperationLoop(String name) {
        String message = "Process: " + name + " defines a cooperation and contains a loop. (Please change this horrible sentence)";
        this.problems.add(ProblemFactory.buildProblem(1179661, this.model.getResolver().getProcessDefinition(name), message));
    }

    public void setProblems() {
        IProblem[] totalProblems = new IProblem[this.model.getProblems().length + this.problems.size()];
        System.arraycopy(this.model.getProblems(), 0, totalProblems, 0, this.model.getProblems().length);
        System.arraycopy(this.problems.toArray(), 0, totalProblems, this.model.getProblems().length, this.problems.size());
        this.model.setProblems(totalProblems);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Problems
    extends LinkedList<IProblem> {
        @Override
        public boolean add(IProblem problem) {
            if (this.hasError()) {
                return false;
            }
            return super.add(problem);
        }

        public boolean hasError() {
            for (IProblem problem : ProblemManager.this.problems) {
                if (!problem.isError()) continue;
                return true;
            }
            return false;
        }
    }
}

