/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.analysis.internal;

import java.util.HashMap;
import java.util.Map;
import uk.ac.ed.inf.pepa.analysis.internal.ProblemManager;
import uk.ac.ed.inf.pepa.analysis.internal.ProcessCounter;

public class ProcessUsageManager {
    private HashMap<String, ProcessCounter> processUsage = new HashMap();
    private ProblemManager problemManager;

    public ProcessUsageManager(ProblemManager problemManager) {
        this.problemManager = problemManager;
    }

    public void lhs(String name) {
        ProcessCounter counter = this.getCounter(name);
        ++counter.lhs;
    }

    public void rhs(String name) {
        ++this.checkLhs((String)name).rhs;
    }

    private ProcessCounter checkLhs(String name) {
        return this.getCounter(name);
    }

    public ProcessCounter getCounter(String name) {
        if (this.processUsage.containsKey(name)) {
            return this.processUsage.get(name);
        }
        ProcessCounter counter = new ProcessCounter();
        this.processUsage.put(name, counter);
        return counter;
    }

    public void warn() {
        for (Map.Entry<String, ProcessCounter> mapEntry : this.processUsage.entrySet()) {
            ProcessCounter counter = mapEntry.getValue();
            String name = mapEntry.getKey();
            if (counter.lhs == 0) {
                this.problemManager.processNotDefinedError(name);
                continue;
            }
            if (counter.lhs > 1) {
                this.problemManager.processMultipleDeclaration(name);
                continue;
            }
            if (counter.rhs != 0) continue;
            this.problemManager.transientStateProblem(name);
        }
    }
}

