/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.analysis.internal;

import java.util.HashMap;
import java.util.Map;
import uk.ac.ed.inf.pepa.analysis.internal.ProblemManager;
import uk.ac.ed.inf.pepa.analysis.internal.RateCounter;

public class RateUsageManager {
    private HashMap<String, RateCounter> rateUsage = new HashMap();
    private ProblemManager problemManager;

    public RateUsageManager(ProblemManager problemManager) {
        this.problemManager = problemManager;
    }

    public void lhs(String name) {
        RateCounter counter = this.getCounter(name);
        ++counter.lhs;
    }

    public void rhs(String name) {
        ++this.checkLhs((String)name).rhs;
    }

    public void process(String name) {
        ++this.checkLhs((String)name).process;
    }

    private RateCounter checkLhs(String name) {
        RateCounter counter = this.getCounter(name);
        if (counter.lhs == 0) {
            this.problemManager.rateNotDefinedProblem(name);
        }
        return counter;
    }

    public void warn() {
        for (Map.Entry<String, RateCounter> mapEntry : this.rateUsage.entrySet()) {
            RateCounter counter = mapEntry.getValue();
            String name = mapEntry.getKey();
            if (counter.lhs > 1) {
                this.problemManager.rateMultipleDeclaration(name);
            }
            if (counter.rhs + counter.process != 0) continue;
            this.problemManager.rateNotUsedProblem(name);
        }
    }

    private RateCounter getCounter(String name) {
        if (this.rateUsage.containsKey(name)) {
            return this.rateUsage.get(name);
        }
        RateCounter counter = new RateCounter();
        this.rateUsage.put(name, counter);
        return counter;
    }
}

