/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.abstraction;

import java.util.ArrayList;
import uk.ac.ed.inf.pepa.ctmc.abstraction.AbstractState;
import uk.ac.ed.inf.pepa.ctmc.abstraction.Abstraction;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ShortArray;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.RateMatrix;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AtomicProperty;

public class SequentialStateSpace {
    private ShortArray states;
    private ArrayList<RateMatrix> registeredMatrices = new ArrayList(10);
    private ArrayList<Abstraction> registeredAbstractions = new ArrayList(10);
    private ArrayList<AtomicProperty> registeredProperties = new ArrayList(10);
    private boolean optimiseFind = false;

    public SequentialStateSpace() {
        this.states = new ShortArray(10);
    }

    public void addState(short state) {
        this.states.addNew(state);
        this.optimiseFind = false;
    }

    public boolean containsState(short state) {
        return this.states.contains(state);
    }

    public int getIndex(short state) {
        return this.states.findPosition(state);
    }

    public short getState(int index) {
        if (!this.optimiseFind) {
            this.states.optimiseFind();
        }
        return this.states.get(index);
    }

    public void reorderStates(AbstractState[] aggregates) {
        int indexCount = 0;
        int i = 0;
        while (i < aggregates.length) {
            short[] concreteStates = aggregates[i].getConcrete();
            int j = 0;
            while (j < concreteStates.length) {
                int currentIndex = this.getIndex(concreteStates[j]);
                if (currentIndex != indexCount) {
                    this.states.swap(currentIndex, indexCount);
                    this.notifySwap(currentIndex, indexCount);
                }
                ++indexCount;
                ++j;
            }
            ++i;
        }
    }

    private void notifySwap(int index1, int index2) {
        for (RateMatrix rateMatrix : this.registeredMatrices) {
            rateMatrix.notifySwap(index1, index2);
        }
        for (Abstraction abstraction : this.registeredAbstractions) {
            abstraction.notifySwap(index1, index2);
        }
        for (AtomicProperty property : this.registeredProperties) {
            property.notifySwap(this, index1, index2);
        }
    }

    public void register(RateMatrix rateMatrix) {
        this.registeredMatrices.add(rateMatrix);
    }

    public void register(Abstraction abstraction) {
        this.registeredAbstractions.add(abstraction);
    }

    public void register(AtomicProperty property) {
        this.registeredProperties.add(property);
    }

    public int size() {
        return this.states.size();
    }
}

