/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation;

import uk.ac.ed.inf.pepa.ctmc.derivation.IFilterRunner;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;
import uk.ac.ed.inf.pepa.ctmc.derivation.filters.ActionFilter;
import uk.ac.ed.inf.pepa.ctmc.derivation.filters.NegationFilter;
import uk.ac.ed.inf.pepa.ctmc.derivation.filters.PatternMatchingFilter;
import uk.ac.ed.inf.pepa.ctmc.derivation.filters.SequentialComponentFilter;
import uk.ac.ed.inf.pepa.ctmc.derivation.filters.SteadyStateThresholdFilter;

public class FilterFactory {
    public static final String VERTICAL_BAR = ":";
    public static final String WILDCARD = "*";

    public static IStateSpaceFilter createSequentialComponentFilter(String componentName, Operator operator, int numCopies) {
        return new SequentialComponentFilter(componentName, operator, numCopies);
    }

    public static IStateSpaceFilter createSteadyStateThreshold(Operator operator, double threshold) {
        return new SteadyStateThresholdFilter(operator, threshold);
    }

    public static IStateSpaceFilter createPatternMatchingFilter(String pattern) {
        return new PatternMatchingFilter(pattern);
    }

    public static IStateSpaceFilter createNegation(IStateSpaceFilter filter) {
        if (filter == null) {
            throw new NullPointerException("Filter is null");
        }
        return new NegationFilter(filter);
    }

    public static IStateSpaceFilter createOr(final IStateSpaceFilter[] filters) {
        if (filters == null) {
            throw new NullPointerException("Filter array is null");
        }
        return new IStateSpaceFilter(){

            public IFilterRunner getRunner(IStateSpace ss) {
                return new OrRunner(ss, filters);
            }
        };
    }

    public static IStateSpaceFilter createUnnamedStatesFilter() {
        return new IStateSpaceFilter(){

            public IFilterRunner getRunner(final IStateSpace ss) {
                return new IFilterRunner(){

                    public boolean select(int stateIndex) {
                        int i = 0;
                        while (i < ss.getNumberOfSequentialComponents(stateIndex)) {
                            if (ss.isUnnamed(stateIndex, i)) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                };
            }
        };
    }

    public static IStateSpaceFilter createActionFilter(String actionType, boolean incoming) {
        if (actionType == null) {
            throw new NullPointerException();
        }
        return new ActionFilter(actionType, incoming);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        LT("<"),
        GT(">"),
        GET(">="),
        LET("<="),
        EQ("=="),
        NEQ("!=");

        private String fValue;

        private Operator(String value) {
            this.fValue = value;
        }

        public String toString() {
            return this.fValue;
        }
    }

    private static class OrRunner
    implements IFilterRunner {
        private IFilterRunner[] runners;

        public OrRunner(IStateSpace stateSpace, IStateSpaceFilter[] filters) {
            this.runners = new IFilterRunner[filters.length];
            int i = 0;
            while (i < filters.length) {
                this.runners[i] = filters[i].getRunner(stateSpace);
                ++i;
            }
        }

        public boolean select(int stateIndex) {
            IFilterRunner[] iFilterRunnerArray = this.runners;
            int n = this.runners.length;
            int n2 = 0;
            while (n2 < n) {
                IFilterRunner r = iFilterRunnerArray[n2];
                if (r.select(stateIndex)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

