/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;

public class Buffer {
    private static final int SIZE = 500;
    private Transition[] buf = new Transition[500];
    private int counter;
    public int maxRequestsPerState;
    public int missedRequests;
    public int totalRequests;
    private int requests;

    public Buffer(int stateVectorSize) {
        int i = 0;
        while (i < 500) {
            Transition t = new Transition();
            t.fTargetProcess = new short[stateVectorSize];
            this.buf[i] = t;
            ++i;
        }
        this.counter = 0;
        this.maxRequestsPerState = 0;
        this.requests = 0;
        this.missedRequests = 0;
        this.totalRequests = 0;
    }

    public void clear() {
        this.maxRequestsPerState = Math.max(this.requests, this.maxRequestsPerState);
        this.totalRequests += this.requests;
        this.counter = 0;
        this.requests = 0;
    }

    public Transition getTransition(short[] state, int offset, int length, short actionId, double rate) {
        ++this.requests;
        Transition newTransition = null;
        if (this.counter == this.buf.length) {
            ++this.missedRequests;
            newTransition = new Transition();
            newTransition.fTargetProcess = new short[state.length];
        } else {
            newTransition = this.buf[this.counter++];
        }
        newTransition.fActionId = actionId;
        newTransition.fRate = rate;
        int i = 0;
        while (i < length) {
            newTransition.fTargetProcess[offset + i] = state[offset + i];
            ++i;
        }
        return newTransition;
    }
}

