/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import uk.ac.ed.inf.pepa.analysis.internal.AlphabetProvider;
import uk.ac.ed.inf.pepa.model.Action;
import uk.ac.ed.inf.pepa.model.ActionSet;
import uk.ac.ed.inf.pepa.model.Activity;
import uk.ac.ed.inf.pepa.model.Aggregation;
import uk.ac.ed.inf.pepa.model.Constant;
import uk.ac.ed.inf.pepa.model.Cooperation;
import uk.ac.ed.inf.pepa.model.FiniteRate;
import uk.ac.ed.inf.pepa.model.Hiding;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.model.NamedRate;
import uk.ac.ed.inf.pepa.model.Prefix;
import uk.ac.ed.inf.pepa.model.Process;
import uk.ac.ed.inf.pepa.model.Rate;
import uk.ac.ed.inf.pepa.model.RateMath;
import uk.ac.ed.inf.pepa.model.internal.ActionSetImpl;
import uk.ac.ed.inf.pepa.model.internal.AggregationImpl;
import uk.ac.ed.inf.pepa.model.internal.ConstantImpl;
import uk.ac.ed.inf.pepa.model.internal.DoMakePepaProcess;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.Actions;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;

public class Compiler {
    HashMap<String, Constant> processes;
    HashMap<String, NamedRate> rates;
    boolean aggregateArrays;
    Model compiledModel;

    public Compiler(boolean aggregateArrays, ModelNode model) {
        this.aggregateArrays = aggregateArrays;
        this.processes = new HashMap();
        this.rates = new HashMap();
        CompilerVisitor c = new CompilerVisitor(this);
        model.accept(c);
        this.compiledModel = (Model)c.compiledObject;
    }

    public Compiler(ModelNode model) {
        this(true, model);
    }

    public Model getModel() {
        return this.compiledModel;
    }

    private static class CompilerVisitor
    implements ASTVisitor {
        Object compiledObject;
        Compiler newCompiler;
        static HashSet<String> currentActions;
        static HashMap<String, HashSet<String>> viewableActions;
        private static final DoMakePepaProcess factory;

        static {
            factory = DoMakePepaProcess.getInstance();
        }

        public CompilerVisitor(Compiler newCompiler) {
            this.newCompiler = newCompiler;
        }

        public void visitActivityNode(ActivityNode activity) {
            CompilerVisitor compAction = new CompilerVisitor(this.newCompiler);
            activity.getAction().accept(compAction);
            Action action = (Action)compAction.compiledObject;
            CompilerVisitor compRate = new CompilerVisitor(this.newCompiler);
            activity.getRate().accept(compRate);
            Rate rate = (Rate)compRate.compiledObject;
            this.compiledObject = factory.createActivity(action, rate);
        }

        public void visitActionTypeNode(ActionTypeNode actionType) {
            this.compiledObject = factory.createNamedAction(actionType.getType());
        }

        public void visitChoiceNode(ChoiceNode choice) {
            CompilerVisitor compLHS = new CompilerVisitor(this.newCompiler);
            CompilerVisitor compRHS = new CompilerVisitor(this.newCompiler);
            choice.getLeft().accept(compLHS);
            HashSet<String> leftActions = currentActions;
            choice.getRight().accept(compRHS);
            currentActions.addAll(leftActions);
            this.compiledObject = factory.createChoice((Process)compLHS.compiledObject, (Process)compRHS.compiledObject);
        }

        public void visitConstantProcessNode(ConstantProcessNode constant) {
            Constant memConstant = null;
            currentActions = new HashSet();
            String name = constant.getName();
            currentActions.addAll((Collection<String>)viewableActions.get(name));
            if (!this.newCompiler.processes.containsKey(name)) {
                memConstant = factory.createConstant(name);
                this.newCompiler.processes.put(name, memConstant);
            } else {
                memConstant = this.newCompiler.processes.get(name);
            }
            this.compiledObject = memConstant;
        }

        public void visitCooperationNode(CooperationNode cooperation) {
            CompilerVisitor compLHS = new CompilerVisitor(this.newCompiler);
            CompilerVisitor compRHS = new CompilerVisitor(this.newCompiler);
            cooperation.getLeft().accept(compLHS);
            HashSet<String> leftActions = currentActions;
            cooperation.getRight().accept(compRHS);
            currentActions.addAll(leftActions);
            this.compiledObject = factory.createCooperation((Process)compLHS.compiledObject, (Process)compRHS.compiledObject, this.createActionSet(cooperation.getActionSet()));
        }

        private ActionSet createActionSet(Actions actions2) {
            ActionSetImpl set = (ActionSetImpl)factory.createActionSet();
            for (ActionTypeNode action : actions2) {
                CompilerVisitor v = new CompilerVisitor(this.newCompiler);
                action.accept(v);
                set.add((Action)v.compiledObject);
            }
            return set;
        }

        public void visitHidingNode(HidingNode hiding) {
            CompilerVisitor v = new CompilerVisitor(this.newCompiler);
            hiding.getProcess().accept(v);
            Hiding memHiding = factory.createHiding((Process)v.compiledObject, this.createActionSet(hiding.getActionSet()));
            this.compiledObject = memHiding;
            for (ActionTypeNode atn : hiding.getActionSet()) {
                currentActions.remove(atn.getType());
            }
        }

        public void visitModelNode(ModelNode model) {
            viewableActions = new AlphabetProvider(model).getViewableActionAlphabets();
            CompilerVisitor v = null;
            Model memModel = factory.createModel(model);
            for (ASTNode def : model.rateDefinitions()) {
                v = new CompilerVisitor(this.newCompiler);
                def.accept(v);
                memModel.getRateDefinitions().add((NamedRate)v.compiledObject);
            }
            for (ASTNode def : model.processDefinitions()) {
                v = new CompilerVisitor(this.newCompiler);
                def.accept(v);
                memModel.getProcessDefinitions().add((Constant)v.compiledObject);
            }
            v = new CompilerVisitor(this.newCompiler);
            model.getSystemEquation().accept(v);
            memModel.setSystemEquation((Process)v.compiledObject);
            this.compiledObject = memModel;
        }

        public void visitPassiveRateNode(PassiveRateNode passive) {
            this.compiledObject = factory.createPassiveRate(passive.getMultiplicity());
        }

        public void visitPrefixNode(PrefixNode prefix) {
            CompilerVisitor v = null;
            v = new CompilerVisitor(this.newCompiler);
            prefix.getActivity().accept(v);
            Activity act = (Activity)v.compiledObject;
            v = new CompilerVisitor(this.newCompiler);
            prefix.getTarget().accept(v);
            Prefix memPrefix = factory.createPrefix(act, (Process)v.compiledObject);
            this.compiledObject = memPrefix;
            if (prefix.getActivity().getAction() instanceof ActionTypeNode) {
                currentActions.add(((ActionTypeNode)prefix.getActivity().getAction()).getType());
            }
        }

        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            CompilerVisitor v = new CompilerVisitor(this.newCompiler);
            processDefinition.getNode().accept(v);
            CompilerVisitor v2 = new CompilerVisitor(this.newCompiler);
            processDefinition.getName().accept(v2);
            Constant constant = (Constant)v2.compiledObject;
            ((ConstantImpl)constant).resolve((Process)v.compiledObject);
            this.compiledObject = constant;
        }

        public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
            CompilerVisitor v = new CompilerVisitor(this.newCompiler);
            rateDefinition.getRate().accept(v);
            NamedRate namedRate = factory.createNamedRate(rateDefinition.getName().getName(), ((FiniteRate)v.compiledObject).getValue());
            this.newCompiler.rates.put(rateDefinition.getName().getName(), namedRate);
            this.compiledObject = namedRate;
        }

        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode binRate) {
            CompilerVisitor v1 = new CompilerVisitor(this.newCompiler);
            binRate.getLeft().accept(v1);
            CompilerVisitor v2 = new CompilerVisitor(this.newCompiler);
            binRate.getRight().accept(v2);
            switch (binRate.getOperator()) {
                case DIV: {
                    this.compiledObject = RateMath.div((Rate)v1.compiledObject, (Rate)v2.compiledObject);
                    break;
                }
                case MINUS: {
                    this.compiledObject = RateMath.minus((Rate)v1.compiledObject, (Rate)v2.compiledObject);
                    break;
                }
                case MULT: {
                    this.compiledObject = RateMath.mult((Rate)v1.compiledObject, (Rate)v2.compiledObject);
                    break;
                }
                case PLUS: {
                    this.compiledObject = RateMath.sum((Rate)v1.compiledObject, (Rate)v2.compiledObject);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
            this.compiledObject = factory.createFiniteRate(doubleRate.getValue());
        }

        public void visitVariableRateNode(VariableRateNode variableRate) {
            this.compiledObject = this.newCompiler.rates.get(variableRate.getName());
        }

        public void visitAggregationNode(AggregationNode aggregation) {
            if (this.newCompiler.aggregateArrays) {
                this.aggregateArrays(aggregation);
            } else {
                this.doNotAggregateArrays(aggregation);
            }
        }

        private void doNotAggregateArrays(AggregationNode aggregation) {
            CompilerVisitor v = new CompilerVisitor(this.newCompiler);
            aggregation.getProcessNode().accept(v);
            Process subProcess = (Process)v.compiledObject;
            int copies = this.getCopies(aggregation);
            if (copies == 1) {
                this.compiledObject = subProcess;
                return;
            }
            Cooperation coop = factory.createCooperation(subProcess, subProcess, factory.createActionSet());
            int i = 0;
            while (i < copies - 2) {
                coop = factory.createCooperation(coop, subProcess, factory.createActionSet());
                ++i;
            }
            this.compiledObject = coop;
        }

        private void aggregateArrays(AggregationNode aggregation) {
            Aggregation compiledAggregation = factory.createAggregation();
            CompilerVisitor v = new CompilerVisitor(this.newCompiler);
            aggregation.getProcessNode().accept(v);
            ((AggregationImpl)compiledAggregation).add((Process)v.compiledObject, this.getCopies(aggregation));
            this.compiledObject = compiledAggregation;
        }

        private int getCopies(AggregationNode aggregation) {
            double dcopies;
            CompilerVisitor vrate = new CompilerVisitor(this.newCompiler);
            aggregation.getCopies().accept(vrate);
            int copies = 0;
            if (vrate.compiledObject instanceof FiniteRate) {
                dcopies = ((FiniteRate)vrate.compiledObject).getValue();
                if (Math.floor(dcopies) != dcopies) {
                    throw new IllegalArgumentException("Expected integer");
                }
            } else {
                throw new IllegalArgumentException("Expected finite integer in aggregation");
            }
            copies = (int)dcopies;
            return copies;
        }

        public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
            this.compiledObject = factory.createSilentAction(null);
        }

        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            CompilerVisitor compLHS = new CompilerVisitor(this.newCompiler);
            CompilerVisitor compRHS = new CompilerVisitor(this.newCompiler);
            cooperation.getLeft().accept(compLHS);
            HashSet<String> leftActions = currentActions;
            cooperation.getRight().accept(compRHS);
            HashSet<String> intersection = new HashSet<String>();
            for (String s : leftActions) {
                if (!currentActions.contains(s)) continue;
                intersection.add(s);
            }
            currentActions.addAll(leftActions);
            ActionSetImpl set = (ActionSetImpl)factory.createActionSet();
            for (String s : intersection) {
                set.add(factory.createNamedAction(s));
            }
            this.compiledObject = factory.createCooperation((Process)compLHS.compiledObject, (Process)compRHS.compiledObject, set);
        }
    }
}

