/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

public class DoubleArray {
    private double[] elementData;
    private int size;

    public DoubleArray(int initialSize) {
        this.elementData = new double[initialSize];
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = this.copyOf(this.elementData, newCapacity);
        }
    }

    private double[] copyOf(double[] original, int newLength) {
        double[] newArray = new double[newLength];
        System.arraycopy(original, 0, newArray, 0, this.size);
        return newArray;
    }

    public void add(double element) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = element;
    }

    public double get(int index) {
        if (index >= 0 && index < this.size) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
    }

    public void trimToSize() {
        if (this.size < this.elementData.length) {
            this.elementData = this.copyOf(this.elementData, this.size);
        }
    }

    public double[] toArray() {
        double[] newArray = new double[this.size];
        System.arraycopy(this.elementData, 0, newArray, 0, this.size);
        return newArray;
    }

    public int size() {
        return this.size;
    }
}

