/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.DoubleArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IntegerArray;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.ICallbackListener;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.MemoryStateSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCallback
implements ICallbackListener {
    private static final int INITIAL_CAPACITY = 1000;
    private IntegerArray row = new IntegerArray(1000);
    private IntegerArray column = new IntegerArray(1000);
    private DoubleArray value = new DoubleArray(2000);
    private IntegerArray action = new IntegerArray(2000);
    private int t;
    private int currentColumn;
    private double sum;
    private short currentAction;
    private int t_count = 0;
    private int maximumLength = 0;
    private boolean hasVariableLength = false;

    @Override
    public IStateSpace done(ISymbolGenerator generator, ArrayList<State> states) throws DerivationException {
        this.row.trimToSize();
        this.column.trimToSize();
        this.value.trimToSize();
        this.action.trimToSize();
        return new MemoryStateSpace(generator, states, this.row, this.column, this.action, this.value, this.hasVariableLength, this.maximumLength);
    }

    @Override
    public void foundDerivatives(State state, Transition[] transitions) {
        this.exploringState(state.stateNumber, transitions.length);
        if (state.stateNumber == 0) {
            this.maximumLength = state.fState.length;
        }
        int oldLength = this.maximumLength;
        this.maximumLength = Math.max(state.fState.length, this.maximumLength);
        if (oldLength != this.maximumLength) {
            this.hasVariableLength = true;
        }
        this.t_count += transitions.length;
        Arrays.sort(transitions);
        int i = 0;
        while (i < transitions.length) {
            Transition t = transitions[i];
            this.foundTransition(state.stateNumber, t.fState.stateNumber, t.fRate, t.fActionId);
            ++i;
        }
    }

    private void exploringState(int state, int numTransitions) {
        this.t = numTransitions;
        this.currentColumn = -1;
        this.row.add(this.column.size());
    }

    private void foundTransition(int i, int j, double rate, short action) {
        if (this.currentColumn != j) {
            if (this.currentColumn != -1) {
                this.writeAction();
            }
            this.column.add(j);
            this.column.add(this.value.size());
            this.currentColumn = j;
            this.currentAction = action;
            this.sum = 0.0;
        }
        if (this.currentAction != action) {
            this.writeAction();
            this.currentAction = action;
            this.sum = rate;
        } else {
            this.sum += rate;
        }
        --this.t;
        if (this.t == 0) {
            this.writeAction();
        }
    }

    private void writeAction() {
        this.action.add(this.currentAction);
        this.value.add(this.sum);
    }
}

