/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

import java.util.Arrays;
import java.util.BitSet;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Component;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.OptimisedRateMath;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;

public class Operator
extends Component {
    private Component fLeft;
    private Component fRight;
    private BitSet fActionSet;

    public Operator() {
        this(null);
    }

    public Operator(String name) {
        super(name);
    }

    public void setCooperationSet(BitSet bitSet) {
        if (bitSet == null) {
            throw new NullPointerException();
        }
        this.fActionSet = bitSet;
    }

    public void compose(short[] state) throws DerivationException {
        Arrays.fill(this.fApparentRates, 0.0);
        this.fFirstStepDerivatives.clear();
        for (Transition leftEntry : this.fLeft.fFirstStepDerivatives) {
            if (!this.fActionSet.get(leftEntry.fActionId)) {
                this.createLeftOnlyTransition(state, leftEntry);
                continue;
            }
            for (Transition rightEntry : this.fRight.fFirstStepDerivatives) {
                if (rightEntry.fActionId != leftEntry.fActionId) continue;
                this.createSharedTransition(state, leftEntry, rightEntry);
            }
        }
        for (Transition rightEntry : this.fRight.fFirstStepDerivatives) {
            if (this.fActionSet.get(rightEntry.fActionId)) continue;
            this.createRightOnlyTransition(state, rightEntry);
        }
    }

    private void createLeftOnlyTransition(short[] state, Transition leftEntry) throws DerivationException {
        Transition t = this.buf.getTransition(state, this.fRight.fOffset, this.fRight.fLength, this.checkAction(leftEntry.fActionId), leftEntry.fRate);
        int i = 0;
        while (i < this.fLeft.fLength) {
            t.fTargetProcess[this.fLeft.fOffset + i] = leftEntry.fTargetProcess[this.fLeft.fOffset + i];
            ++i;
        }
        double left = this.fLeft.fApparentRates[t.fActionId];
        if (left == 0.0 && t.fActionId != -1) {
            throw new IllegalStateException("There must be an apparent rate!");
        }
        double right = this.fRight.fApparentRates[t.fActionId];
        Operator.assertSameType(left, right);
        this.update(t, left + right);
    }

    private void createRightOnlyTransition(short[] state, Transition rightEntry) throws DerivationException {
        Transition t = this.buf.getTransition(state, this.fLeft.fOffset, this.fLeft.fLength, this.checkAction(rightEntry.fActionId), rightEntry.fRate);
        int i = 0;
        while (i < this.fRight.fLength) {
            t.fTargetProcess[this.fRight.fOffset + i] = rightEntry.fTargetProcess[this.fRight.fOffset + i];
            ++i;
        }
        double left = this.fLeft.fApparentRates[t.fActionId];
        double right = this.fRight.fApparentRates[t.fActionId];
        if (right == 0.0 && t.fActionId != -1) {
            throw new IllegalStateException("There must be an apparent rate!");
        }
        Operator.assertSameType(left, right);
        this.update(t, left + right);
    }

    private static void assertSameType(double rate1, double rate2) throws DerivationException {
        if (!OptimisedRateMath.areSameType(rate1, rate2)) {
            throw new DerivationException("Mixing passive and active rates.");
        }
    }

    private void createSharedTransition(short[] state, Transition leftEntry, Transition rightEntry) {
        short sharedActionId = leftEntry.fActionId;
        double apparentRateLeft = this.fLeft.fApparentRates[sharedActionId];
        double apparentRateRight = this.fRight.fApparentRates[sharedActionId];
        double minApparentRates = OptimisedRateMath.min(apparentRateLeft, apparentRateRight);
        double first = leftEntry.fRate / apparentRateLeft;
        double second = rightEntry.fRate / apparentRateRight;
        double temp = first * second;
        double finalRate = temp * minApparentRates;
        Transition t = this.buf.getTransition(state, 0, 0, this.checkAction(sharedActionId), finalRate);
        short[] newState = t.fTargetProcess;
        int i = 0;
        while (i < this.fLeft.fLength) {
            newState[this.fLeft.fOffset + i] = leftEntry.fTargetProcess[this.fLeft.fOffset + i];
            ++i;
        }
        i = 0;
        while (i < this.fRight.fLength) {
            newState[this.fRight.fOffset + i] = rightEntry.fTargetProcess[this.fRight.fOffset + i];
            ++i;
        }
        this.update(t, minApparentRates);
    }

    private final short checkAction(short action) {
        return this.fHidingSet.get(action) ? (short)-1 : (short)action;
    }

    private Transition createTransition(short[] newState, short actionId, double rate) {
        Transition transition = null;
        transition.fTargetProcess = newState;
        transition.fActionId = this.fHidingSet.get(actionId) ? (short)-1 : actionId;
        transition.fRate = rate;
        return transition;
    }

    private final void update(Transition transition, double apparentRate) {
        this.fFirstStepDerivatives.add(transition);
        this.fApparentRates[transition.fActionId] = apparentRate;
    }

    public String toString() {
        return this.getName() != null ? this.getName() : "Left: " + this.fLeft + " Right:" + this.fRight;
    }

    public Component getLeftChild() {
        return this.fLeft;
    }

    public Component getRightChild() {
        return this.fRight;
    }

    public void setLeftChild(Component leftChild) {
        this.fLeft = leftChild;
        this.updateOffsetAndLength();
    }

    public void setRightChild(Component rightChild) {
        this.fRight = rightChild;
        this.updateOffsetAndLength();
    }

    private void updateOffsetAndLength() {
        if (this.fLeft != null) {
            this.fOffset = this.fLeft.fOffset;
            if (this.fRight != null) {
                this.fLength = this.fLeft.fLength + this.fRight.fLength;
            }
        }
    }
}

