/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;

public class OptimisedHashMap {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private int stateNumber = 0;

    public OptimisedHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public OptimisedHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public OptimisedHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private State old_getKey(State key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int hash = OptimisedHashMap.hash(key.hashCode());
        Entry e = this.table[OptimisedHashMap.indexFor(hash, this.table.length)];
        while (e != null) {
            State k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                return e.key;
            }
            e = e.next;
        }
        return null;
    }

    private State old_getKey(short[] key, int hashCode) {
        int hash = OptimisedHashMap.hash(hashCode);
        int i = OptimisedHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && Arrays.equals(e.key.fState, key)) {
                return e.key;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized InsertionResult putIfNotPresentSync(short[] key, int hashCode) {
        int hash = OptimisedHashMap.hash(hashCode);
        int i = OptimisedHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && Arrays.equals(e.key.fState, key)) {
                return new InsertionResult(e.key, true);
            }
            e = e.next;
        }
        State state = new State(key, hashCode);
        state.stateNumber = this.stateNumber++;
        ++this.modCount;
        this.addEntry(hash, state, i);
        return new InsertionResult(state, false);
    }

    public InsertionResult old_putIfNotPresentSync(short[] key, int hashCode) {
        Entry e;
        int hash = OptimisedHashMap.hash(hashCode);
        int i = OptimisedHashMap.indexFor(hash, this.table.length);
        this.rLock.lock();
        try {
            e = this.table[i];
            while (e != null) {
                if (e.hash == hash && Arrays.equals(e.key.fState, key)) {
                    InsertionResult insertionResult = new InsertionResult(e.key, true);
                    return insertionResult;
                }
                e = e.next;
            }
        }
        finally {
            this.rLock.unlock();
        }
        this.wLock.lock();
        try {
            i = OptimisedHashMap.indexFor(hash, this.table.length);
            e = this.table[i];
            while (e != null) {
                if (e.hash == hash && Arrays.equals(e.key.fState, key)) {
                    InsertionResult insertionResult = new InsertionResult(e.key, true);
                    return insertionResult;
                }
                e = e.next;
            }
            State state = new State(key, hashCode);
            state.stateNumber = this.stateNumber++;
            ++this.modCount;
            this.addEntry(hash, state, i);
            InsertionResult insertionResult = new InsertionResult(state, false);
            return insertionResult;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public InsertionResult putIfNotPresentUnsync(short[] key, int hashCode) {
        int hash = OptimisedHashMap.hash(hashCode);
        int i = OptimisedHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && Arrays.equals(e.key.fState, key)) {
                return new InsertionResult(e.key, true);
            }
            e = e.next;
        }
        State state = new State(key, hashCode);
        state.stateNumber = this.stateNumber++;
        ++this.modCount;
        this.addEntry(hash, state, i);
        return new InsertionResult(state, false);
    }

    private Object old_put(State key) {
        int hash = OptimisedHashMap.hash(key.hashCode());
        int i = OptimisedHashMap.indexFor(hash, this.table.length);
        ++this.modCount;
        this.addEntry(hash, key, i);
        return null;
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            Entry e = src[j];
            if (e != null) {
                Entry next;
                src[j] = null;
                do {
                    next = e.next;
                    int i = OptimisedHashMap.indexFor(e.hash, newCapacity);
                    e.next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
            ++j;
        }
    }

    private void old_clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
    }

    void addEntry(int hash, State key, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, key, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    static class Entry {
        final State key;
        Entry next;
        final int hash;

        Entry(int h, State k, Entry n) {
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public final State getKey() {
            return this.key;
        }
    }

    public class InsertionResult {
        public State state;
        public boolean wasPresent;

        public InsertionResult(State state, boolean wasPresent) {
            this.state = state;
            this.wasPresent = wasPresent;
        }
    }
}

