/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.common;

public class ShortArray {
    private short[] elementData;
    private int[] reverseLookup = null;
    private short minElement = 0;
    private short maxElement = 0;
    private int size = 0;

    public ShortArray(int initialSize) {
        this.elementData = new short[initialSize];
    }

    public ShortArray(short[] initialArray) {
        this.size = initialArray.length;
        this.elementData = new short[this.size];
        if (this.size > 0) {
            this.minElement = initialArray[0];
            this.maxElement = initialArray[0];
        }
        int i = 0;
        while (i < this.size) {
            short element;
            this.elementData[i] = element = initialArray[i];
            this.minElement = (short)Math.min(this.minElement, element);
            this.maxElement = (short)Math.max(this.maxElement, element);
            ++i;
        }
    }

    public ShortArray(ShortArray copy) {
        this.elementData = new short[copy.elementData.length];
        this.reverseLookup = new int[copy.reverseLookup.length];
        System.arraycopy(copy.elementData, 0, this.elementData, 0, copy.elementData.length);
        System.arraycopy(copy.reverseLookup, 0, this.reverseLookup, 0, copy.reverseLookup.length);
        this.minElement = copy.minElement;
        this.maxElement = copy.maxElement;
        this.size = copy.size;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = this.copyOf(this.elementData, newCapacity);
        }
    }

    private void changed() {
        this.reverseLookup = null;
    }

    private short[] copyOf(short[] original, int newLength) {
        short[] newArray = new short[newLength];
        System.arraycopy(original, 0, newArray, 0, this.size);
        return newArray;
    }

    public void add(short element) {
        if (this.size == 0) {
            this.minElement = element;
            this.maxElement = element;
        }
        this.minElement = (short)Math.min(this.minElement, element);
        this.maxElement = (short)Math.max(this.maxElement, element);
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = element;
        this.changed();
    }

    public void add(short[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            this.add(elements[i]);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void remove(short element) {
        numFound = 0;
        i = 0;
        ** GOTO lbl9
        {
            ++numFound;
            do {
                if (i + numFound < this.size && this.elementData[i + numFound] == element) continue block0;
                this.elementData[i] = i + numFound >= this.size ? 0 : this.elementData[i + numFound];
                ++i;
lbl9:
                // 2 sources

            } while (i < this.size);
        }
        this.size -= numFound;
        this.changed();
    }

    public void clear() {
        this.size = 0;
        this.changed();
    }

    public void addNew(short element) {
        if (!this.contains(element)) {
            this.add(element);
        }
    }

    public short get(int index) {
        if (index >= 0 && index < this.size) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
    }

    public boolean contains(short x) {
        int i = 0;
        while (i < this.size()) {
            if (this.elementData[i] == x) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void optimiseFind() {
        this.reverseLookup = new int[this.maxElement - this.minElement + 1];
        int i = 0;
        while (i < this.reverseLookup.length) {
            this.reverseLookup[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.size()) {
            this.reverseLookup[this.elementData[i] - this.minElement] = (short)i;
            ++i;
        }
    }

    public int findPosition(short x) {
        if (this.reverseLookup == null) {
            int i = 0;
            while (i < this.size()) {
                if (this.elementData[i] == x) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        if (x < this.minElement || x > this.maxElement) {
            return -1;
        }
        return this.reverseLookup[x - this.minElement];
    }

    public void swap(int index1, int index2) {
        short state2;
        short state1 = this.get(index1);
        this.elementData[index1] = state2 = this.get(index2);
        this.elementData[index2] = state1;
        if (this.reverseLookup != null) {
            this.reverseLookup[state1 - this.minElement] = index2;
            this.reverseLookup[state2 - this.minElement] = index1;
        }
    }

    public void trimToSize() {
        if (this.size < this.elementData.length) {
            this.elementData = this.copyOf(this.elementData, this.size);
        }
    }

    public short[] toArray() {
        short[] newArray = new short[this.size];
        System.arraycopy(this.elementData, 0, newArray, 0, this.size);
        return newArray;
    }

    public int size() {
        return this.size;
    }
}

