/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.filters;

import java.util.ArrayList;
import uk.ac.ed.inf.pepa.ctmc.derivation.IFilterRunner;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;

public class PatternMatchingFilter
implements IStateSpaceFilter {
    private String pattern;

    public PatternMatchingFilter(String pattern) {
        this.pattern = pattern;
    }

    public IFilterRunner getRunner(IStateSpace stateSpace) {
        return new FilterRunner(stateSpace);
    }

    private class FilterRunner
    implements IFilterRunner {
        private ArrayList<PatternData> fList = new ArrayList();
        private IStateSpace ss;

        public FilterRunner(IStateSpace ss) {
            this.ss = ss;
            String[] individualComponents = PatternMatchingFilter.this.pattern.split(":");
            int i = 0;
            while (i < individualComponents.length) {
                String comp = individualComponents[i].trim();
                if (!comp.equals("*")) {
                    PatternData d = new PatternData();
                    d.position = i;
                    d.processId = ss.getProcessId(comp);
                    if (d.processId == -1) {
                        throw new IllegalArgumentException("Component " + comp + " does not exist");
                    }
                    this.fList.add(d);
                }
                ++i;
            }
        }

        public boolean select(int state) {
            for (PatternData d : this.fList) {
                if (this.ss.getProcessId(state, d.position) == d.processId) continue;
                return false;
            }
            return true;
        }
    }

    private class PatternData {
        int position;
        short processId;

        private PatternData() {
        }
    }
}

