/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal;

import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.model.NamedAction;
import uk.ac.ed.inf.pepa.model.Process;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolGenerator
implements ISymbolGenerator {
    private Map<Short, Process> processMap;
    private Map<Short, NamedAction> actionMap;
    private short[] initialState;

    public SymbolGenerator(short[] initialState, Map<Short, Process> processMap, Map<Short, NamedAction> actionMap) {
        this.initialState = initialState;
        this.processMap = processMap;
        this.actionMap = actionMap;
    }

    @Override
    public String getActionLabel(short actionId) {
        NamedAction action = this.actionMap.get(actionId);
        return action == null ? (actionId == -1 ? "tau" : null) : action.prettyPrint();
    }

    @Override
    public short getActionId(String action) {
        for (Map.Entry<Short, NamedAction> entry : this.actionMap.entrySet()) {
            if (!action.equals(entry.getValue().prettyPrint())) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public short getIndex(Process process) {
        for (Map.Entry<Short, Process> entry : this.processMap.entrySet()) {
            if (!process.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public short[] getInitialState() {
        return this.initialState;
    }

    @Override
    public int getNumOfCopies(short processId, short[] state) {
        int copies = 0;
        short[] sArray = state;
        int n = state.length;
        int n2 = 0;
        while (n2 < n) {
            short id = sArray[n2];
            if (processId == id) {
                ++copies;
            }
            ++n2;
        }
        return copies;
    }

    @Override
    public short getProcessId(String process) {
        for (Map.Entry<Short, Process> entry : this.processMap.entrySet()) {
            if (!process.equals(entry.getValue().prettyPrint())) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public String getProcessLabel(short processId) {
        Process process = this.processMap.get(processId);
        return process == null ? null : process.prettyPrint();
    }

    @Override
    public Map<Short, Process> getSequentialComponentMap() {
        return this.processMap;
    }

    @Override
    public Collection<String> getSequentialComponentNames() {
        TreeSet<String> set = new TreeSet<String>();
        Collection<Process> processes = this.processMap.values();
        for (Process p : processes) {
            set.add(p.prettyPrint());
        }
        return set;
    }
}

