/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.io.IOException;
import java.io.RandomAccessFile;

public class DiskIntegerArray {
    public static final int BYTE_SIZE = 2;
    private RandomAccessFile file;
    private int size;

    public DiskIntegerArray(String file) throws IOException {
        this.file = new RandomAccessFile(file, "r");
        long longSize = this.file.length() >> 2;
        if (longSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("File too long");
        }
        this.size = (int)longSize;
    }

    public int get(int index) throws IOException {
        int pos = index << 2;
        this.file.seek(pos);
        int result = this.file.readInt();
        return result;
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public void getBulk(int from, int to, int[] dest) throws IOException {
        this.file.seek(from << 2);
        int range = to - from;
        int i = 0;
        while (i < range) {
            dest[i] = this.file.readInt();
            ++i;
        }
    }

    public int size() {
        return this.size;
    }
}

