/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.MeasurementData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IStateExplorer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.MemoryCallback;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.OptimisedHashMap;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.DiskCallback;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.hbf.ICallbackListener;

public class SequentialBuilder
implements IStateSpaceBuilder {
    private final ISymbolGenerator generator;
    private IStateExplorer explorer;
    private IResourceManager manager;
    private static final int REFRESH_MONITOR = 20000;
    private int id;

    public SequentialBuilder(IStateExplorer explorer, ISymbolGenerator generator, int productId, IResourceManager manager) {
        this.explorer = explorer;
        this.generator = generator;
        this.id = productId;
        this.manager = manager;
    }

    public IStateSpace derive(boolean allowPassiveRates, IProgressMonitor monitor) throws DerivationException {
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        monitor.beginTask(-1);
        ICallbackListener ss = null;
        ArrayList<State> states = new ArrayList<State>(1000);
        switch (this.id) {
            case 1: {
                ss = new MemoryCallback();
                break;
            }
            case 0: {
                ss = new DiskCallback(this.manager);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        OptimisedHashMap map = new OptimisedHashMap();
        LinkedList<State> queue = new LinkedList<State>();
        short[] initialState = this.generator.getInitialState();
        int hashCode = Arrays.hashCode(initialState);
        State initState = map.putIfNotPresentUnsync((short[])initialState, (int)hashCode).state;
        queue.add(initState);
        int transitions = 0;
        Transition[] found = null;
        while (!queue.isEmpty()) {
            if (monitor.isCanceled()) {
                monitor.done();
                return null;
            }
            State s = (State)queue.remove();
            if (s.stateNumber % 20000 == 0) {
                monitor.worked(20000);
            }
            try {
                found = this.explorer.exploreState(s.fState);
            }
            catch (DerivationException e) {
                throw this.createException(s, e.getMessage());
            }
            if (found.length == 0) {
                monitor.done();
                throw this.createException(s, "Deadlock found.");
            }
            transitions += found.length;
            int i = 0;
            while (i < found.length) {
                Transition aT = found[i];
                if (aT.fRate <= 0.0) {
                    throw this.createException(s, "Incomplete model with respect to action: " + this.generator.getActionLabel(aT.fActionId) + ". ");
                }
                hashCode = Arrays.hashCode(aT.fTargetProcess);
                OptimisedHashMap.InsertionResult result = map.putIfNotPresentUnsync(aT.fTargetProcess, hashCode);
                aT.fState = result.state;
                if (!result.wasPresent) {
                    queue.add(result.state);
                }
                ++i;
            }
            ss.foundDerivatives(s, found);
            states.add(s);
        }
        this.explorer.dispose();
        states.trimToSize();
        IStateSpace stateSpace = ss.done(this.generator, states);
        monitor.done();
        return stateSpace;
    }

    private DerivationException createException(State state, String message) {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(message) + " State number: ");
        buf.append(String.valueOf(state.stateNumber) + ". ");
        buf.append("State: ");
        int i = 0;
        while (i < state.fState.length) {
            buf.append(this.generator.getProcessLabel(state.fState[i]));
            if (i != state.fState.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        return new DerivationException(buf.toString());
    }

    public MeasurementData getMeasurementData() {
        return null;
    }
}

